/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.namemanager.listeners;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.namemanager.dialog.NameManagerDialog;
import org.openstreetmap.josm.plugins.namemanager.utils.NameManagerUtils;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Document;

public class NameManagerAction
extends JosmAction
implements SelectionChangedListener {
    private static final String ATTRIBUTE_DISTRICTS = "Attribute districts";
    private static final String NAME_MANAGER = "Name Manager";
    private static final String NAME_MANAGER_MENU = "selectall";
    private static final long serialVersionUID = 5638780111409126823L;

    public NameManagerAction() {
        super(I18n.tr((String)NAME_MANAGER, (Object[])new Object[0]), NAME_MANAGER_MENU, I18n.tr((String)ATTRIBUTE_DISTRICTS, (Object[])new Object[0]), null, true, "namemanager", true);
        DataSet.addSelectionListener((SelectionChangedListener)this);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        NameManagerDialog dialog = NameManagerDialog.getInstance();
        Way selectedWay = (Way)Main.main.getCurrentDataSet().getSelectedWays().iterator().next();
        dialog.setSelectedWay(selectedWay);
        dialog.setWaysInsideSelectedArea(NameManagerUtils.getWaysInsideSelectedArea(selectedWay));
        Document doc = NameManagerUtils.parseCountries();
        doc.getDocumentElement().normalize();
        NameManagerUtils.prepareCountryDataMemoryCache(doc);
        dialog.setCountryComboBox();
        dialog.repaint();
        dialog.setVisible(true);
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.setEnabled(newSelection != null && Main.main.getCurrentDataSet().getSelectedWays().size() == 1 && ((Way)Main.main.getCurrentDataSet().getSelectedWays().iterator().next()).firstNode() == ((Way)Main.main.getCurrentDataSet().getSelectedWays().iterator().next()).lastNode());
    }
}

