/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagerycache;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.plugins.imagerycache.DBTile;
import org.openstreetmap.josm.plugins.imagerycache.TileDAO;

public class TileDAOMapDB
implements TileDAO {
    public static final boolean debug = new BooleanProperty("imagerycache.debug", false).get();
    public static final boolean noMmap = new BooleanProperty("imagerycache.randomAccessFile", false).get();
    public static boolean dbNotAvailable = false;
    protected HashMap<String, DB> dbs = new HashMap();
    protected HashMap<String, Map<Long, DBTile>> storages = new HashMap();
    private File cacheFolder;
    static TileDAOMapDB instance = new TileDAOMapDB();

    public static TileDAOMapDB getInstance() {
        return instance;
    }

    private synchronized DB initDB(String source) {
        DB db = this.dbs.get(source);
        if (db != null) {
            return db;
        }
        File f = null;
        for (int attempt = 0; attempt < 20; ++attempt) {
            try {
                File lock;
                String fname = this.getDBFileName(source, attempt);
                f = new File(this.cacheFolder, fname);
                f.createNewFile();
                if (f.exists() && !f.canWrite() || !(lock = new File(this.cacheFolder, fname + ".lock")).createNewFile()) continue;
                lock.deleteOnExit();
                db = noMmap ? DBMaker.newFileDB(f).randomAccessFileEnable().writeAheadLogDisable().closeOnJvmShutdown().make() : DBMaker.newFileDB(f).randomAccessFileEnableIfNeeded().writeAheadLogDisable().closeOnJvmShutdown().make();
                this.dbs.put(source, db);
                HTreeMap m = db.getHashMap("tiles");
                this.storages.put(source, m);
                System.out.println("Opened database file successfully: " + f.getAbsolutePath());
            }
            catch (Exception ex) {
                System.out.println("Error: can not create database, file: " + f.getAbsolutePath());
                ex.printStackTrace();
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new RuntimeException(ex);
            }
            this.mergeSources(source);
            return db;
        }
        db = DBMaker.newMemoryDB().asyncWriteDisable().writeAheadLogDisable().closeOnJvmShutdown().make();
        this.dbs.put(source, db);
        HTreeMap m = db.getHashMap("tiles");
        this.storages.put(source, m);
        return db;
    }

    private synchronized Map<Long, DBTile> getStorage(String source) {
        if (!this.storages.containsKey(source)) {
            this.initDB(source);
        }
        Map<Long, DBTile> m = this.storages.get(source);
        return m;
    }

    private TileDAOMapDB() {
    }

    void setCacheFolder(File f) {
        this.cacheFolder = f;
    }

    @Override
    public DBTile getById(String source, long id) {
        if (dbNotAvailable) {
            return null;
        }
        return this.getStorage(source).get(id);
    }

    @Override
    public synchronized void updateModTime(String source, long id, DBTile dbTile) {
        if (debug) {
            System.out.println("Tile " + id + ": Updating modification time");
        }
        if (dbNotAvailable) {
            return;
        }
        this.getStorage(source).put(id, dbTile);
    }

    @Override
    public synchronized void updateTile(String source, long id, DBTile dbTile) {
        if (debug) {
            System.out.println("Tile " + id + ": Updating tile in base");
        }
        if (dbNotAvailable) {
            return;
        }
        this.getStorage(source).put(id, dbTile);
    }

    @Override
    public synchronized void deleteTile(String source, long id) {
        if (dbNotAvailable) {
            return;
        }
        this.getStorage(source).remove(id);
    }

    private String getDBFileName(String source, int attempt) {
        String fname = "tiles_" + source.replaceAll("[\\\\/:*?\"<>| ]", "_");
        if (attempt > 0) {
            fname = fname + "_" + attempt;
        }
        return fname;
    }

    private void mergeSources(String source) {
        DB db = null;
        Map<Long, DBTile> myMap = this.storages.get(source);
        for (int t = 0; t < 20; ++t) {
            try {
                File lock;
                String fname = this.getDBFileName(source, t);
                File f = new File(this.cacheFolder, fname);
                if (!f.exists() || !f.canWrite() || (lock = new File(this.cacheFolder, fname + ".lock")).exists()) continue;
                db = DBMaker.newFileDB(f).randomAccessFileEnableIfNeeded().writeAheadLogDisable().closeOnJvmShutdown().make();
                HTreeMap m = db.getHashMap("tiles");
                System.out.println("Moving records from " + f.getName() + " to open storage " + source);
                myMap.putAll(m);
                db.close();
                new File(this.cacheFolder, fname + ".p").delete();
                f.delete();
                System.out.println("Moved database successfully from file " + f.getAbsolutePath());
                continue;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                try {
                    if (db == null) continue;
                    db.close();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void cleanStorage(String name) {
        Main.info((String)"Cleaning storage: {0}", (Object[])new Object[]{name});
        this.dbs.get(name).close();
        for (int t = 0; t < 20; ++t) {
            try {
                String fname = this.getDBFileName(name, t);
                File f = new File(this.cacheFolder, fname);
                if (!f.exists() || !f.canWrite()) continue;
                f.delete();
                continue;
            }
            catch (Exception e) {
                Main.warn((String)"Can not delete file");
            }
        }
    }
}

