/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.taggingpresettester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSelector;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingPresetTester
extends JFrame {
    private TaggingPresetSelector taggingPresets;
    private final String[] args;
    private JPanel taggingPresetPanel = new JPanel(new BorderLayout());
    private JPanel panel = new JPanel(new GridBagLayout());

    public final void reload() {
        this.taggingPresets.init(TaggingPresetReader.readAll(Arrays.asList(this.args), (boolean)true));
    }

    public final void reselect() {
        this.taggingPresetPanel.removeAll();
        TaggingPreset preset = this.taggingPresets.getSelectedPreset();
        if (preset == null) {
            return;
        }
        Collection x = Main.main != null && Main.main.hasEditLayer() ? Main.main.getCurrentDataSet().getSelected() : this.makeFakeSuitablePrimitive(preset);
        TaggingPreset.PresetPanel p = preset.createPanel(x);
        if (p != null) {
            p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.taggingPresetPanel.add((Component)p, "North");
        }
        this.panel.validate();
        this.panel.repaint();
    }

    public TaggingPresetTester(String[] args) {
        super(I18n.tr((String)"Tagging Preset Tester", (Object[])new Object[0]));
        this.args = args;
        this.taggingPresets = new TaggingPresetSelector();
        this.taggingPresetPanel.setPreferredSize(new Dimension(300, 500));
        this.reload();
        this.panel.add((Component)this.taggingPresets, GBC.std((int)0, (int)0).fill(1));
        this.panel.add((Component)this.taggingPresetPanel, GBC.std((int)1, (int)0).fill(1));
        this.taggingPresets.addSelectionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TaggingPresetTester.this.taggingPresets.getSelectedPreset() != null) {
                    TaggingPresetTester.this.reselect();
                }
            }
        });
        this.reselect();
        JButton b = new JButton(I18n.tr((String)"Reload", (Object[])new Object[0]));
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaggingPreset p = TaggingPresetTester.this.taggingPresets.getSelectedPreset();
                TaggingPresetTester.this.reload();
                if (p != null) {
                    TaggingPresetTester.this.taggingPresets.setSelectedPreset(p);
                }
            }
        });
        this.panel.add((Component)b, GBC.std((int)0, (int)1).span(2, 1).fill(2));
        this.setContentPane(this.panel);
        this.setSize(600, 500);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JFileChooser c = new JFileChooser();
            if (c.showOpenDialog(null) != 0) {
                return;
            }
            args = new String[]{c.getSelectedFile().getPath()};
        }
        if (args != null) {
            Main.pref = new Preferences();
            System.out.println("Opening file " + args[0]);
            TaggingPresetTester f = new TaggingPresetTester(args);
            f.setDefaultCloseOperation(3);
            f.setVisible(true);
        }
    }

    private Collection<OsmPrimitive> makeFakeSuitablePrimitive(TaggingPreset preset) {
        if (preset.typeMatches(Collections.singleton(TaggingPresetType.NODE))) {
            return Collections.singleton(new Node());
        }
        if (preset.typeMatches(Collections.singleton(TaggingPresetType.WAY))) {
            return Collections.singleton(new Way());
        }
        if (preset.typeMatches(Collections.singleton(TaggingPresetType.RELATION))) {
            return Collections.singleton(new Relation());
        }
        if (preset.typeMatches(Collections.singleton(TaggingPresetType.CLOSEDWAY))) {
            Way w = new Way();
            w.addNode(new Node(new LatLon(0.0, 0.0)));
            w.addNode(new Node(new LatLon(0.0, 1.0)));
            w.addNode(new Node(new LatLon(1.0, 1.0)));
            w.addNode(new Node(new LatLon(0.0, 0.0)));
            return Collections.singleton(w);
        }
        return Collections.emptySet();
    }
}

