/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.taggingpresettester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.plugins.taggingpresettester.TaggingCellRenderer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingPresetTester
extends JFrame {
    private JComboBox taggingPresets;
    private final String[] args;
    private JPanel taggingPresetPanel = new JPanel(new BorderLayout());
    private JPanel panel = new JPanel(new BorderLayout());

    public final void reload() {
        Vector allPresets = new Vector(TaggingPreset.readAll(Arrays.asList(this.args), (boolean)true));
        this.taggingPresets.setModel(new DefaultComboBoxModel(allPresets));
    }

    public final void reselect() {
        this.taggingPresetPanel.removeAll();
        TaggingPreset preset = (TaggingPreset)this.taggingPresets.getSelectedItem();
        if (preset == null) {
            return;
        }
        Collection<OsmPrimitive> x = Main.main.hasEditLayer() ? Main.main.getCurrentDataSet().getSelected() : this.makeFakeSuitablePrimitive(preset);
        TaggingPreset.PresetPanel p = preset.createPanel(x);
        if (p != null) {
            p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.taggingPresetPanel.add((Component)p, "North");
        }
        this.panel.validate();
        this.panel.repaint();
    }

    public TaggingPresetTester(String[] args) {
        super(I18n.tr((String)"Tagging Preset Tester", (Object[])new Object[0]));
        this.args = args;
        this.taggingPresets = new JComboBox();
        this.taggingPresets.setRenderer(new TaggingCellRenderer());
        this.reload();
        this.panel.add((Component)this.taggingPresets, "North");
        this.panel.add((Component)this.taggingPresetPanel, "Center");
        this.taggingPresets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaggingPresetTester.this.reselect();
            }
        });
        this.reselect();
        JButton b = new JButton(I18n.tr((String)"Reload", (Object[])new Object[0]));
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = TaggingPresetTester.this.taggingPresets.getSelectedIndex();
                TaggingPresetTester.this.reload();
                if (i < TaggingPresetTester.this.taggingPresets.getItemCount()) {
                    TaggingPresetTester.this.taggingPresets.setSelectedIndex(i);
                }
            }
        });
        this.panel.add((Component)b, "South");
        this.setContentPane(this.panel);
        this.setSize(300, 500);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JFileChooser c = new JFileChooser();
            if (c.showOpenDialog(null) != 0) {
                return;
            }
            args = new String[]{c.getSelectedFile().getPath()};
        }
        TaggingPresetTester f = new TaggingPresetTester(args);
        f.setDefaultCloseOperation(3);
    }

    private Collection<OsmPrimitive> makeFakeSuitablePrimitive(TaggingPreset preset) {
        if (preset.typeMatches(Collections.singleton(TaggingPreset.PresetType.NODE))) {
            return Collections.singleton(new Node());
        }
        if (preset.typeMatches(Collections.singleton(TaggingPreset.PresetType.WAY))) {
            return Collections.singleton(new Way());
        }
        if (preset.typeMatches(Collections.singleton(TaggingPreset.PresetType.RELATION))) {
            return Collections.singleton(new Relation());
        }
        if (preset.typeMatches(Collections.singleton(TaggingPreset.PresetType.CLOSEDWAY))) {
            Way w = new Way();
            w.addNode(new Node(new LatLon(0.0, 0.0)));
            w.addNode(new Node(new LatLon(0.0, 1.0)));
            w.addNode(new Node(new LatLon(1.0, 1.0)));
            w.addNode(new Node(new LatLon(0.0, 0.0)));
            return Collections.singleton(w);
        }
        return Collections.emptySet();
    }
}

