/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.DataInputBlock;
import org.apache.poi.poifs.storage.ListManagedBlock;

public final class SmallDocumentBlock
implements BlockWritable,
ListManagedBlock {
    private static final int BLOCK_SHIFT = 6;
    private byte[] _data = new byte[64];
    private static final byte _default_fill = -1;
    private static final int _block_size = 64;
    private static final int BLOCK_MASK = 63;

    private SmallDocumentBlock(POIFSBigBlockSize pOIFSBigBlockSize, byte[] byArray, int n) {
        this(pOIFSBigBlockSize);
        System.arraycopy(byArray, n * 64, this._data, 0, 64);
    }

    private SmallDocumentBlock(POIFSBigBlockSize pOIFSBigBlockSize) {
    }

    private static int getBlocksPerBigBlock(POIFSBigBlockSize pOIFSBigBlockSize) {
        return pOIFSBigBlockSize.getBigBlockSize() / 64;
    }

    public static SmallDocumentBlock[] convert(POIFSBigBlockSize pOIFSBigBlockSize, byte[] byArray, int n) {
        SmallDocumentBlock[] smallDocumentBlockArray = new SmallDocumentBlock[(n + 64 - 1) / 64];
        int n2 = 0;
        for (int i = 0; i < smallDocumentBlockArray.length; ++i) {
            smallDocumentBlockArray[i] = new SmallDocumentBlock(pOIFSBigBlockSize);
            if (n2 < byArray.length) {
                int n3 = Math.min(64, byArray.length - n2);
                System.arraycopy(byArray, n2, smallDocumentBlockArray[i]._data, 0, n3);
                if (n3 != 64) {
                    Arrays.fill(smallDocumentBlockArray[i]._data, n3, 64, (byte)-1);
                }
            } else {
                Arrays.fill(smallDocumentBlockArray[i]._data, (byte)-1);
            }
            n2 += 64;
        }
        return smallDocumentBlockArray;
    }

    public static SmallDocumentBlock[] convert(POIFSBigBlockSize pOIFSBigBlockSize, BlockWritable[] blockWritableArray, int n) throws IOException, ArrayIndexOutOfBoundsException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < blockWritableArray.length; ++i) {
            blockWritableArray[i].writeBlocks(byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        SmallDocumentBlock[] smallDocumentBlockArray = new SmallDocumentBlock[SmallDocumentBlock.convertToBlockCount(n)];
        for (int i = 0; i < smallDocumentBlockArray.length; ++i) {
            smallDocumentBlockArray[i] = new SmallDocumentBlock(pOIFSBigBlockSize, byArray, i);
        }
        return smallDocumentBlockArray;
    }

    public static List<SmallDocumentBlock> extract(POIFSBigBlockSize pOIFSBigBlockSize, ListManagedBlock[] listManagedBlockArray) throws IOException {
        int n = SmallDocumentBlock.getBlocksPerBigBlock(pOIFSBigBlockSize);
        ArrayList<SmallDocumentBlock> arrayList = new ArrayList<SmallDocumentBlock>();
        for (int i = 0; i < listManagedBlockArray.length; ++i) {
            byte[] byArray = listManagedBlockArray[i].getData();
            for (int j = 0; j < n; ++j) {
                arrayList.add(new SmallDocumentBlock(pOIFSBigBlockSize, byArray, j));
            }
        }
        return arrayList;
    }

    public static DataInputBlock getDataInputBlock(SmallDocumentBlock[] smallDocumentBlockArray, int n) {
        int n2 = n >> 6;
        int n3 = n & 0x3F;
        return new DataInputBlock(smallDocumentBlockArray[n2]._data, n3);
    }

    public static int calcSize(int n) {
        return n * 64;
    }

    private static int convertToBlockCount(int n) {
        return (n + 64 - 1) / 64;
    }

    @Override
    public void writeBlocks(OutputStream outputStream) throws IOException {
        outputStream.write(this._data);
    }

    @Override
    public byte[] getData() {
        return this._data;
    }
}

