/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.modules;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.SourceProvider;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.modules.Module;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;

public abstract class AbstractModule
implements Module,
OdConstants {
    protected final List<Class<? extends AbstractDataSetHandler>> handlers = new ArrayList<Class<? extends AbstractDataSetHandler>>();
    private final List<AbstractDataSetHandler> instanciatedHandlers = new ArrayList<AbstractDataSetHandler>();
    protected final ModuleInformation info;

    public AbstractModule(ModuleInformation info) {
        this.info = info;
    }

    @Override
    public ModuleInformation getModuleInformation() {
        return this.info;
    }

    @Override
    public List<Class<? extends AbstractDataSetHandler>> getHandlers() {
        return this.handlers;
    }

    @Override
    public String getDisplayedName() {
        return this.info.name;
    }

    @Override
    public SourceProvider getMapPaintStyleSourceProvider() {
        final ArrayList<SourceEditor.ExtendedSourceEntry> sources = new ArrayList<SourceEditor.ExtendedSourceEntry>();
        for (AbstractDataSetHandler handler : this.getInstanciatedHandlers()) {
            SourceEditor.ExtendedSourceEntry src;
            if (handler == null || (src = handler.getMapPaintStyle()) == null) continue;
            try {
                String path = OdPlugin.getInstance().getResourcesDirectory() + File.separator + src.url.replace("resource://", "").replace('/', File.separatorChar);
                int n = 0;
                byte[] buffer = new byte[4096];
                InputStream in = this.getClass().getResourceAsStream(src.url.substring("resource://".length() - 1));
                new File(path.substring(0, path.lastIndexOf(File.separatorChar))).mkdirs();
                FileOutputStream out = new FileOutputStream(path);
                while ((n = in.read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                }
                out.close();
                in.close();
                src.url = "file://" + path;
                sources.add(src);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return sources.isEmpty() ? null : new SourceProvider(){

            public Collection<SourceEntry> getSources() {
                return sources;
            }
        };
    }

    @Override
    public SourceProvider getPresetSourceProvider() {
        final ArrayList<SourceEditor.ExtendedSourceEntry> sources = new ArrayList<SourceEditor.ExtendedSourceEntry>();
        for (AbstractDataSetHandler handler : this.getInstanciatedHandlers()) {
            if (handler == null || handler.getTaggingPreset() == null) continue;
            sources.add(handler.getTaggingPreset());
        }
        return sources.isEmpty() ? null : new SourceProvider(){

            public Collection<SourceEntry> getSources() {
                return sources;
            }
        };
    }

    @Override
    public final List<AbstractDataSetHandler> getNewlyInstanciatedHandlers() {
        ArrayList<AbstractDataSetHandler> result = new ArrayList<AbstractDataSetHandler>();
        for (Class<? extends AbstractDataSetHandler> handlerClass : this.handlers) {
            if (handlerClass == null) continue;
            try {
                result.add(handlerClass.newInstance());
            }
            catch (Throwable t) {
                System.err.println("Cannot instantiate " + handlerClass + " because of " + t.getClass().getName() + ": " + t.getMessage());
            }
        }
        return result;
    }

    private final List<AbstractDataSetHandler> getInstanciatedHandlers() {
        if (this.instanciatedHandlers.isEmpty()) {
            this.instanciatedHandlers.addAll(this.getNewlyInstanciatedHandlers());
        }
        return this.instanciatedHandlers;
    }
}

