/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.NationalHandlers;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoCrsException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeoMathTransformException;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GeographicReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GmlHandler;

public class GmlReader
extends GeographicReader {
    public static final String GML_FEATURE_MEMBER = "featureMember";
    public static final String GML_LINE_STRING = "LineString";
    public static final String GML_LINEAR_RING = "LinearRing";
    public static final String GML_SURFACE = "Surface";
    public static final String GML_SRS_NAME = "srsName";
    public static final String GML_SRS_DIMENSION = "srsDimension";
    public static final String GML_POS_LIST = "posList";
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final GmlHandler gmlHandler;
    private XMLStreamReader parser;
    private int dim;
    private final Map<String, CrsData> crsDataMap = new HashMap<String, CrsData>();

    public GmlReader(XMLStreamReader parser, GmlHandler handler) {
        super(handler, NationalHandlers.DEFAULT_GML_HANDLERS);
        this.parser = parser;
        this.gmlHandler = handler;
    }

    public static DataSet parseDataSet(InputStream in, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException, XMLStreamException {
        UTFInputStreamReader ir = UTFInputStreamReader.create((InputStream)in, (String)"UTF-8");
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader((Reader)ir);
        try {
            return new GmlReader(parser, handler != null ? handler.getGmlHandler() : null).parseDoc(instance);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private final boolean isElement(String element) {
        return this.parser.getLocalName().matches("(gml:)?" + element);
    }

    private DataSet parseDoc(ProgressMonitor instance) throws XMLStreamException, GeoCrsException, FactoryException, GeoMathTransformException, MismatchedDimensionException, TransformException {
        Component parent;
        Component component = parent = instance != null ? instance.getWindowParent() : Main.parent;
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event != 1 || !this.isElement(GML_FEATURE_MEMBER)) continue;
            try {
                this.parseFeatureMember(parent);
            }
            catch (UserCancelException e) {
                return this.ds;
            }
        }
        return this.ds;
    }

    private void findCRS(String srs) throws NoSuchAuthorityCodeException, FactoryException {
        System.out.println("Finding CRS for " + srs);
        if (this.gmlHandler != null) {
            this.crs = this.gmlHandler.getCrsFor(srs);
        } else {
            for (GmlHandler h : NationalHandlers.DEFAULT_GML_HANDLERS) {
                this.crs = h.getCrsFor(srs);
                if (this.crs == null) continue;
                return;
            }
        }
    }

    private void parseSrs(Component parent) throws GeoCrsException, FactoryException, UserCancelException, GeoMathTransformException {
        String srs = this.parser.getAttributeValue(null, GML_SRS_NAME);
        this.dim = Integer.parseInt(this.parser.getAttributeValue(null, GML_SRS_DIMENSION));
        CrsData crsData = this.crsDataMap.get(srs);
        if (crsData == null) {
            try {
                this.findCRS(srs);
            }
            catch (NoSuchAuthorityCodeException e) {
                e.printStackTrace();
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
            if (this.crs == null) {
                throw new GeoCrsException("Unable to detect CRS for srs '" + srs + "' !");
            }
            this.findMathTransform(parent, false);
            this.crsDataMap.put(srs, new CrsData(this.crs, this.transform, this.dim));
        } else {
            this.crs = crsData.crs;
            this.transform = crsData.transform;
            this.dim = crsData.dim;
        }
    }

    private void parseFeatureMember(Component parent) throws XMLStreamException, GeoCrsException, FactoryException, UserCancelException, GeoMathTransformException, MismatchedDimensionException, TransformException {
        ArrayList<Way> list = new ArrayList<Way>();
        Way way = null;
        Node node = null;
        HashMap tags = new HashMap();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                if (this.isElement(GML_LINE_STRING)) {
                    way = this.createWay();
                    list.add(way);
                    this.parseSrs(parent);
                    continue;
                }
                if (this.isElement(GML_LINEAR_RING)) {
                    way = this.createWay();
                    list.add(way);
                    continue;
                }
                if (this.isElement(GML_SURFACE)) {
                    this.parseSrs(parent);
                    continue;
                }
                if (!this.isElement(GML_POS_LIST)) continue;
                String[] stringArray = this.parser.getElementText().split(" ");
                for (int i = 0; i < stringArray.length; i += this.dim) {
                    Point p = this.geometryFactory.createPoint(new Coordinate(Double.valueOf(stringArray[i]).doubleValue(), Double.valueOf(stringArray[i + 1]).doubleValue()));
                    node = this.createOrGetNode(p, this.dim > 2 && !stringArray[i + 2].equals("0") ? stringArray[i + 2] : null);
                    if (way == null) continue;
                    way.addNode(node);
                }
                continue;
            }
            if (event != 2 || !this.isElement(GML_FEATURE_MEMBER)) continue;
            break;
        }
        for (OsmPrimitive osmPrimitive : list) {
            for (String key : tags.keySet()) {
                osmPrimitive.put(key, (String)tags.get(key));
            }
        }
    }

    private final class CrsData {
        public CoordinateReferenceSystem crs;
        public MathTransform transform;
        public int dim;

        public CrsData(CoordinateReferenceSystem crs, MathTransform transform, int dim) {
            this.crs = crs;
            this.transform = transform;
            this.dim = dim;
        }
    }
}

