/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.gui.DialogPrompter;
import org.openstreetmap.josm.plugins.opendata.core.io.NeptuneReader;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ArchiveHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.CandidateChooser;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GmlReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmlReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmzReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.TabReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.OdsReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.XlsReader;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;

public abstract class ArchiveReader
extends AbstractReader
implements OdConstants {
    protected final AbstractDataSetHandler handler;
    protected final ArchiveHandler archiveHandler;
    protected final boolean promptUser;
    private File file;

    public ArchiveReader(AbstractDataSetHandler handler, ArchiveHandler archiveHandler, boolean promptUser) {
        this.handler = handler;
        this.archiveHandler = archiveHandler;
        this.promptUser = promptUser;
    }

    public final File getReadFile() {
        return this.file;
    }

    protected abstract void extractArchive(File var1, List<File> var2) throws IOException, FileNotFoundException;

    protected abstract String getTaskMessage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet parseDoc(final ProgressMonitor progressMonitor) throws IOException, XMLStreamException, FactoryConfigurationError, JAXBException {
        File temp = OdUtils.createTempDir();
        final ArrayList<File> candidates = new ArrayList<File>();
        try {
            DialogPrompter prompt;
            if (progressMonitor != null) {
                progressMonitor.beginTask(this.getTaskMessage());
            }
            this.extractArchive(temp, candidates);
            this.file = null;
            if (this.promptUser && candidates.size() > 1) {
                prompt = new DialogPrompter(){

                    protected CandidateChooser buildDialog() {
                        return new CandidateChooser(progressMonitor.getWindowParent(), candidates);
                    }
                };
                if (prompt.promptInEdt().getValue() == 1) {
                    this.file = ((CandidateChooser)((Object)prompt.getDialog())).getSelectedFile();
                }
            } else if (!candidates.isEmpty()) {
                this.file = (File)candidates.get(0);
            }
            if (this.file == null) {
                prompt = null;
                return prompt;
            }
            if (!this.file.exists()) {
                Main.warn((String)("File does not exist: " + this.file.getPath()));
                prompt = null;
                return prompt;
            }
            DataSet from = null;
            FileInputStream in = new FileInputStream(this.file);
            ProgressMonitor instance = null;
            if (progressMonitor != null) {
                instance = progressMonitor.createSubTaskMonitor(-1, false);
            }
            if (this.file.getName().toLowerCase().endsWith("csv")) {
                from = CsvReader.parseDataSet(in, this.handler, instance);
            } else if (this.file.getName().toLowerCase().endsWith("kml")) {
                from = KmlReader.parseDataSet(in, instance);
            } else if (this.file.getName().toLowerCase().endsWith("kmz")) {
                from = KmzReader.parseDataSet(in, instance);
            } else if (this.file.getName().toLowerCase().endsWith("xls")) {
                from = XlsReader.parseDataSet(in, this.handler, instance);
            } else if (this.file.getName().toLowerCase().endsWith("ods")) {
                from = OdsReader.parseDataSet(in, this.handler, instance);
            } else if (this.file.getName().toLowerCase().endsWith("shp")) {
                from = ShpReader.parseDataSet(in, this.file, this.handler, instance);
            } else if (this.file.getName().toLowerCase().endsWith("mif")) {
                from = MifReader.parseDataSet(in, this.file, this.handler, instance);
            } else if (this.file.getName().toLowerCase().endsWith("tab")) {
                from = TabReader.parseDataSet(in, this.file, this.handler, instance);
            } else if (this.file.getName().toLowerCase().endsWith("gml")) {
                from = GmlReader.parseDataSet(in, this.handler, instance);
            } else if (this.file.getName().toLowerCase().endsWith("xml")) {
                if (OdPlugin.getInstance().xmlImporter.acceptFile(this.file)) {
                    from = NeptuneReader.parseDataSet(in, this.handler, instance);
                } else {
                    System.err.println("Unsupported XML file: " + this.file.getName());
                }
            } else {
                System.err.println("Unsupported file extension: " + this.file.getName());
            }
            if (from != null) {
                this.ds = from;
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
        finally {
            OdUtils.deleteDir(temp);
            if (progressMonitor != null) {
                progressMonitor.finishTask();
            }
        }
        return this.ds;
    }

    protected final void lookForCandidate(String entryName, List<File> candidates, File file) {
        for (String ext : new String[]{"csv", "kml", "kmz", "xls", "ods", "shp", "mif", "tab", "gml"}) {
            if (!entryName.toLowerCase().endsWith("." + ext)) continue;
            candidates.add(file);
            System.out.println(entryName);
            break;
        }
        if (XML_FILE_FILTER.accept(file) && (this.archiveHandler != null && this.archiveHandler.skipXsdValidation() || OdPlugin.getInstance().xmlImporter.acceptFile(file))) {
            candidates.add(file);
            System.out.println(entryName);
        }
    }
}

