
package org.j7zip.SevenZip.Compression.Copy;

import org.j7zip.SevenZip.HRESULT;
import org.j7zip.SevenZip.ICompressCoder;
import org.j7zip.SevenZip.ICompressProgressInfo;


public class Decoder implements ICompressCoder {
    
    static final int kBufferSize = 1 << 17;
    
    public int Code(
            java.io.InputStream inStream, // , ISequentialInStream
            java.io.OutputStream outStream, // ISequentialOutStream
            long outSize, ICompressProgressInfo progress) throws java.io.IOException {
        
        byte [] _buffer = new byte[kBufferSize];
        long TotalSize = 0;
        
        for (;;) {
            int realProcessedSize;
            int size = kBufferSize;
            
            if (outSize != -1) // NULL
                if (size > (outSize - TotalSize))
                    size = (int)(outSize - TotalSize);
            
            realProcessedSize = inStream.read(_buffer, 0,size);
            if(realProcessedSize == -1) // EOF
                break;
            outStream.write(_buffer,0,realProcessedSize);
            TotalSize += realProcessedSize;
            if (progress != null) {
                int res = progress.SetRatioInfo(TotalSize, TotalSize);
                if (res != HRESULT.S_OK) return res;
            }
        }
        return HRESULT.S_OK;  
    }
}
