/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import neptune.AreaType;
import neptune.ChouetteAreaType;
import neptune.ChouettePTNetworkType;
import neptune.LineType;
import neptune.LocationType;
import neptune.LongLatTypeType;
import neptune.PTLinkType;
import neptune.PTNetworkType;
import neptune.PointType;
import neptune.StopAreaType;
import neptune.StopPointType;
import neptune.TridentObjectType;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchConstants;
import org.xml.sax.SAXException;

public class NeptuneReader
extends AbstractReader
implements FrenchConstants {
    public static final String OSM_PUBLIC_TRANSPORT = "public_transport";
    public static final String OSM_STOP = "stop";
    public static final String OSM_STOP_AREA = "stop_area";
    public static final String OSM_STOP_POSITION = "stop_position";
    public static final String OSM_PLATFORM = "platform";
    public static final String OSM_STATION = "station";
    public static final String OSM_NETWORK = "network";
    public static final String OSM_ROUTE = "route";
    public static final String OSM_ROUTE_MASTER = "route_master";
    public static final String OSM_TRAIN = "train";
    public static final String OSM_SUBWAY = "subway";
    public static final String OSM_MONORAIL = "monorail";
    public static final String OSM_TRAM = "tram";
    public static final String OSM_BUS = "bus";
    public static final String OSM_TROLLEYBUS = "trolleybus";
    public static final String OSM_AERIALWAY = "aerialway";
    public static final String OSM_FERRY = "ferry";
    private static final List<URL> schemas = new ArrayList<URL>();
    private ChouettePTNetworkType root;
    private final Map<String, OsmPrimitive> tridentObjects = new HashMap<String, OsmPrimitive>();

    public static final boolean acceptsXmlNeptuneFile(File file) {
        return NeptuneReader.acceptsXmlNeptuneFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean acceptsXmlNeptuneFile(File file, URL schemaURL) {
        if (schemaURL == null) {
            schemaURL = schemas.get(0);
        }
        try {
            FileInputStream in = new FileInputStream(file);
            StreamSource xmlFile = new StreamSource(in);
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(schemaURL);
                Validator validator = schema.newValidator();
                validator.validate(xmlFile);
                System.out.println(xmlFile.getSystemId() + " is valid");
                boolean bl = true;
                return bl;
            }
            catch (SAXException e) {
                System.out.println(xmlFile.getSystemId() + " is NOT valid");
                System.out.println("Reason: " + e.getLocalizedMessage());
                return false;
            }
            catch (IOException e) {
                System.out.println(xmlFile.getSystemId() + " is NOT valid");
                System.out.println("Reason: " + e.getLocalizedMessage());
                return false;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        return false;
    }

    public static DataSet parseDataSet(InputStream in, AbstractDataSetHandler handler, ProgressMonitor instance) throws JAXBException {
        return new NeptuneReader().parse(in, instance);
    }

    protected static final <T> T unmarshal(Class<T> docClass, InputStream inputStream) throws JAXBException {
        String packageName = docClass.getPackage().getName();
        JAXBContext jc = JAXBContext.newInstance((String)packageName, (ClassLoader)NeptuneReader.class.getClassLoader());
        Unmarshaller u = jc.createUnmarshaller();
        JAXBElement doc = (JAXBElement)u.unmarshal(inputStream);
        return (T)doc.getValue();
    }

    private final void linkTridentObjectToOsmPrimitive(TridentObjectType object, OsmPrimitive p) {
        p.put("ref:neptune", object.getObjectId());
        if (this.tridentObjects.put(object.getObjectId(), p) != null) {
            System.err.println("Trident object duplicated !!! : " + object.getObjectId());
        }
    }

    protected Node createNode(LatLon latlon) {
        Node n = new Node(latlon);
        this.ds.addPrimitive((OsmPrimitive)n);
        return n;
    }

    private Node createPlatform(StopPointType stop) {
        Node n = this.createNode(this.createLatLon(stop));
        n.put(OSM_PUBLIC_TRANSPORT, OSM_PLATFORM);
        this.linkTridentObjectToOsmPrimitive(stop, (OsmPrimitive)n);
        n.put("name", stop.getName());
        return n;
    }

    private Node createStopPosition(StopPointType stop) {
        Node n = this.createNode(this.createLatLon(stop));
        n.put(OSM_PUBLIC_TRANSPORT, OSM_STOP_POSITION);
        this.linkTridentObjectToOsmPrimitive(stop, (OsmPrimitive)n);
        n.put("name", stop.getName());
        return n;
    }

    protected Relation createRelation(String type) {
        Relation r = new Relation();
        r.put("type", type);
        this.ds.addPrimitive((OsmPrimitive)r);
        return r;
    }

    protected Relation createPtRelation(String pt, TridentObjectType object) {
        Relation r = this.createRelation(OSM_PUBLIC_TRANSPORT);
        r.put(OSM_PUBLIC_TRANSPORT, pt);
        this.linkTridentObjectToOsmPrimitive(object, (OsmPrimitive)r);
        return r;
    }

    protected Relation createNetwork(PTNetworkType network) {
        Relation r = this.createRelation(OSM_NETWORK);
        this.linkTridentObjectToOsmPrimitive(network, (OsmPrimitive)r);
        r.put("name", network.getName());
        return r;
    }

    protected Relation createRouteMaster(LineType line) {
        Relation r = this.createPtRelation(OSM_ROUTE_MASTER, line);
        switch (line.getTransportModeName()) {
            case BUS: {
                r.put(OSM_ROUTE_MASTER, OSM_BUS);
                break;
            }
            case AIR: {
                r.put(OSM_ROUTE_MASTER, OSM_AERIALWAY);
                break;
            }
            case FERRY: {
                r.put(OSM_ROUTE_MASTER, OSM_FERRY);
                break;
            }
            case METRO: {
                r.put(OSM_ROUTE_MASTER, OSM_SUBWAY);
                break;
            }
            case TRAIN: {
                r.put(OSM_ROUTE_MASTER, OSM_TRAIN);
                break;
            }
            case TRAMWAY: {
                r.put(OSM_ROUTE_MASTER, OSM_TRAM);
                break;
            }
            case TROLLEYBUS: {
                r.put(OSM_ROUTE_MASTER, OSM_TROLLEYBUS);
                break;
            }
            default: {
                System.err.println("Unsupported transport mode: " + (Object)((Object)line.getTransportModeName()));
            }
        }
        r.put("ref", line.getNumber());
        r.put("name", line.getTransportModeName().value() + " " + line.getNumber() + ": " + line.getName());
        return r;
    }

    private Relation createRoute(ChouettePTNetworkType.ChouetteLineDescription.ChouetteRoute route) {
        Relation r = this.createPtRelation(OSM_ROUTE, route);
        r.put("name", route.getName());
        return r;
    }

    protected Relation createStopArea(StopAreaType sa) {
        Relation r = this.createPtRelation(OSM_STOP_AREA, sa);
        r.put("name", sa.getName());
        return r;
    }

    protected LatLon createLatLon(PointType point) {
        return new LatLon(point.getLatitude().doubleValue(), point.getLongitude().doubleValue());
    }

    protected final <T extends TridentObjectType> T findTridentObject(List<T> list, String id) {
        for (TridentObjectType object : list) {
            if (!object.getObjectId().equals(id)) continue;
            return (T)object;
        }
        return null;
    }

    protected ChouettePTNetworkType.ChouetteLineDescription.StopPoint findStopPoint(String id) {
        return this.findTridentObject(this.root.getChouetteLineDescription().getStopPoint(), id);
    }

    protected ChouettePTNetworkType.ChouetteArea.StopArea findStopArea(String id) {
        return this.findTridentObject(this.root.getChouetteArea().getStopArea(), id);
    }

    protected ChouettePTNetworkType.ChouetteArea.AreaCentroid findAreaCentroid(String id) {
        return this.findTridentObject(this.root.getChouetteArea().getAreaCentroid(), id);
    }

    protected PTLinkType findPtLink(String id) {
        return this.findTridentObject(this.root.getChouetteLineDescription().getPtLink(), id);
    }

    protected static final boolean isNullLatLon(LatLon ll) {
        return ll.lat() == 0.0 && ll.lon() == 0.0;
    }

    private DataSet parse(InputStream in, ProgressMonitor instance) throws JAXBException {
        this.root = NeptuneReader.unmarshal(ChouettePTNetworkType.class, in);
        Relation network = this.createNetwork(this.root.getPTNetwork());
        for (ChouettePTNetworkType.ChouetteArea.StopArea sa : this.root.getChouetteArea().getStopArea()) {
            if (sa.getStopAreaExtension().getAreaType().equals((Object)ChouetteAreaType.COMMERCIAL_STOP_POINT)) {
                Relation stopArea = this.createStopArea(sa);
                stopArea.put("name", sa.getName());
                for (String childId : sa.getContains()) {
                    LocationType child;
                    if (childId.contains("StopArea")) {
                        child = this.findStopArea(childId);
                        if (child == null) {
                            System.err.println("Cannot find StopArea: " + childId);
                            continue;
                        }
                        if (((ChouettePTNetworkType.ChouetteArea.StopArea)child).getStopAreaExtension().getAreaType().equals((Object)ChouetteAreaType.BOARDING_POSITION)) {
                            for (String grandchildId : ((AreaType)child).getContains()) {
                                if (grandchildId.contains("StopPoint")) {
                                    ChouettePTNetworkType.ChouetteLineDescription.StopPoint grandchild = this.findStopPoint(grandchildId);
                                    if (grandchild == null) {
                                        System.err.println("Cannot find StopPoint: " + grandchildId);
                                        continue;
                                    }
                                    if (grandchild.getLongLatType().equals((Object)LongLatTypeType.WGS_84)) {
                                        Node platform = this.createPlatform(grandchild);
                                        stopArea.addMember(new RelationMember(OSM_PLATFORM, (OsmPrimitive)platform));
                                        continue;
                                    }
                                    System.err.println("Unsupported long/lat type: " + (Object)((Object)grandchild.getLongLatType()));
                                    continue;
                                }
                                System.err.println("Unsupported grandchild: " + grandchildId);
                            }
                            String centroidId = ((AreaType)child).getCentroidOfArea();
                            ChouettePTNetworkType.ChouetteArea.AreaCentroid areaCentroid = this.findAreaCentroid(centroidId);
                            if (areaCentroid == null) {
                                System.err.println("Cannot find AreaCentroid: " + centroidId);
                                continue;
                            }
                            if (!areaCentroid.getLongLatType().equals((Object)LongLatTypeType.WGS_84)) {
                                System.err.println("Unsupported long/lat type: " + (Object)((Object)areaCentroid.getLongLatType()));
                                continue;
                            }
                            for (RelationMember member : stopArea.getMembers()) {
                                if (!member.getRole().equals(OSM_PLATFORM) || !NeptuneReader.isNullLatLon(member.getNode().getCoor())) continue;
                                member.getNode().setCoor(this.createLatLon(areaCentroid));
                            }
                            continue;
                        }
                        System.err.println("Unsupported child type: " + (Object)((Object)((ChouettePTNetworkType.ChouetteArea.StopArea)child).getStopAreaExtension().getAreaType()));
                        continue;
                    }
                    if (childId.contains("StopPoint")) {
                        child = this.findStopPoint(childId);
                        if (child == null) {
                            System.err.println("Cannot find StopPoint: " + childId);
                            continue;
                        }
                        System.out.println("TODO: handle StopPoint " + childId);
                        continue;
                    }
                    System.err.println("Unsupported child: " + childId);
                }
                continue;
            }
            if (sa.getStopAreaExtension().getAreaType().equals((Object)ChouetteAreaType.BOARDING_POSITION)) continue;
            System.err.println("Unsupported StopArea type: " + (Object)((Object)sa.getStopAreaExtension().getAreaType()));
        }
        Relation routeMaster = this.createRouteMaster(this.root.getChouetteLineDescription().getLine());
        network.addMember(new RelationMember(null, (OsmPrimitive)routeMaster));
        for (ChouettePTNetworkType.ChouetteLineDescription.ChouetteRoute cr : this.root.getChouetteLineDescription().getChouetteRoute()) {
            Relation route = this.createRoute(cr);
            routeMaster.addMember(new RelationMember(null, (OsmPrimitive)route));
            for (String id : cr.getPtLinkId()) {
                PTLinkType ptlink = this.findPtLink(id);
                if (ptlink == null) {
                    System.err.println("Cannot find PTLinkType: " + id);
                    continue;
                }
                OsmPrimitive start = this.tridentObjects.get(ptlink.getStartOfLink());
                OsmPrimitive end = this.tridentObjects.get(ptlink.getEndOfLink());
                if (start == null) {
                    System.err.println("Cannot find start StopPoint: " + ptlink.getStartOfLink());
                } else if (start.get(OSM_PUBLIC_TRANSPORT).equals(OSM_STOP) || start.get(OSM_PUBLIC_TRANSPORT).equals(OSM_PLATFORM)) {
                    NeptuneReader.addStopToRoute(route, start);
                }
                if (end == null) {
                    System.err.println("Cannot find end StopPoint: " + ptlink.getEndOfLink());
                    continue;
                }
                if (!end.get(OSM_PUBLIC_TRANSPORT).equals(OSM_STOP) && !end.get(OSM_PUBLIC_TRANSPORT).equals(OSM_PLATFORM)) continue;
                NeptuneReader.addStopToRoute(route, end);
            }
        }
        return this.ds;
    }

    private static final boolean addStopToRoute(Relation route, OsmPrimitive stop) {
        if (route.getMembersCount() == 0 || !route.getMember(route.getMembersCount() - 1).getMember().equals((Object)stop)) {
            route.addMember(new RelationMember(stop.get(OSM_PUBLIC_TRANSPORT), stop));
            return true;
        }
        return false;
    }

    public static List<URL> getSchemas() {
        return schemas;
    }

    public static void registerSchema(URL resource) {
        if (resource != null && !schemas.contains(resource)) {
            schemas.add(resource);
        }
    }

    static {
        schemas.add(NeptuneReader.class.getResource("/resources/neptune/neptune.xsd"));
    }
}

