/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.CzechAddressPlugin;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Database;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Region;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Suburb;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ViToCi;
import org.openstreetmap.josm.plugins.czechaddress.gui.databaseeditors.EditorFactory;
import org.openstreetmap.josm.plugins.czechaddress.gui.utils.HalfCookedTreeModel;
import org.openstreetmap.josm.plugins.czechaddress.gui.utils.UniversalTreeRenderer;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Capitalizator;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.tools.ImageProvider;

public class ManagerDialog
extends ExtendedDialog {
    RenameModel<Street> streetModel = new RenameModel();
    private AddressElement dbTreeValue = null;
    private JButton dbEditButton;
    private JTree dbTree;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JPanel mainPanel;
    private JTable renameTable;
    private JButton renamerButton;
    private JScrollPane streetScrollPane;
    private JTabbedPane tabbedPane;

    public ManagerDialog() {
        super(Main.parent, "Inspektor datab\u00e1ze", new String[0], true);
        this.initComponents();
        this.dbTree.setModel(new DatabaseModel());
        this.dbTree.setCellRenderer(new UniversalTreeRenderer());
        this.dbEditButton.setIcon(ImageProvider.get((String)"actions", (String)"edit.png"));
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            Capitalizator cap = new Capitalizator(dataSet.allPrimitives(), CzechAddressPlugin.getLocation().getStreets());
            for (Street capStreet : cap.getCapitalised()) {
                String primName;
                assert (cap.translate(capStreet).get("name") != null) : capStreet;
                String elemName = capStreet.getName();
                if (elemName.equals(primName = cap.translate(capStreet).get("name"))) continue;
                this.streetModel.elems.add(capStreet);
                this.streetModel.names.add(primName);
            }
        }
        this.renameTable.setModel(this.streetModel);
        this.renameTable.setDefaultRenderer(AddressElement.class, new AddressElementRenderer());
        this.renameTable.setDefaultRenderer(String.class, new AddressElementRenderer());
        this.setContent(this.mainPanel);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setupDialog();
    }

    public int countAutomaticRenameProposals() {
        return this.streetModel.getRowCount();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.streetScrollPane = new JScrollPane();
        this.renameTable = new JTable();
        this.renamerButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.dbTree = new JTree();
        this.dbEditButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.mainPanel.setLayout(new GridLayout(1, 0));
        this.renameTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"P\u016fvodn\u00ed n\u00e1zev", "N\u00e1vrh z mapy"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.renameTable.setColumnSelectionAllowed(true);
        this.streetScrollPane.setViewportView(this.renameTable);
        this.renamerButton.setText("Pou\u017e\u00edt navr\u017een\u00e9 zm\u011bny");
        this.renamerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.renamerButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(253, Short.MAX_VALUE).addComponent(this.renamerButton).addContainerGap()).addComponent(this.streetScrollPane, -1, 426, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.streetScrollPane, -1, 342, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.renamerButton).addContainerGap()));
        this.tabbedPane.addTab("N\u00e1vrhy na p\u0159ejmenov\u00e1n\u00ed", this.jPanel1);
        this.dbTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ManagerDialog.this.dbTreeValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.dbTree);
        this.dbEditButton.setText("Upravit");
        this.dbEditButton.setEnabled(false);
        this.dbEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManagerDialog.this.dbEditButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 426, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(356, Short.MAX_VALUE).addComponent(this.dbEditButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 342, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dbEditButton).addContainerGap()));
        this.tabbedPane.addTab("Inspektor datab\u00e1ze", this.jPanel2);
        this.mainPanel.add(this.tabbedPane);
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renamerButtonActionPerformed(ActionEvent evt) {
        Reasoner r;
        assert (this.streetModel.elems.size() == this.streetModel.names.size());
        Reasoner reasoner = r = Reasoner.getInstance();
        synchronized (reasoner) {
            r.openTransaction();
            for (int i = 0; i < this.streetModel.elems.size(); ++i) {
                ((Street)this.streetModel.elems.get(i)).setName(this.streetModel.names.get(i));
                r.update((AddressElement)this.streetModel.elems.get(i));
            }
            r.closeTransaction();
        }
        this.streetModel.elems.clear();
        this.streetModel.names.clear();
        this.jPanel1.setVisible(false);
    }

    private void dbTreeValueChanged(TreeSelectionEvent evt) {
        try {
            this.dbTreeValue = (AddressElement)this.dbTree.getSelectionPath().getLastPathComponent();
        }
        catch (NullPointerException except) {
            this.dbTreeValue = null;
            System.err.println("Strange exception has occurred. If you find a way to reproduce it, please report a bug!");
            except.printStackTrace();
        }
        this.dbEditButton.setEnabled(EditorFactory.isEditable(this.dbTreeValue));
    }

    private void dbEditButtonActionPerformed(ActionEvent evt) {
        if (EditorFactory.isEditable(this.dbTreeValue)) {
            if (EditorFactory.edit(this.dbTreeValue)) {
                this.dbTree.repaint();
            }
        } else {
            this.dbEditButton.setEnabled(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RenameModel<Element>
    implements TableModel {
        List<Element> elems = new ArrayList<Element>();
        List<String> names = new ArrayList<String>();

        private RenameModel() {
        }

        @Override
        public int getRowCount() {
            assert (this.elems.size() == this.names.size());
            return this.elems.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "P\u016fvodn\u00ed n\u00e1zev";
            }
            if (columnIndex == 1) {
                return "Navr\u017een\u00fd n\u00e1zev";
            }
            assert (false) : columnIndex;
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return AddressElement.class;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            assert (false) : columnIndex;
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.elems.get(rowIndex);
            }
            if (columnIndex == 1) {
                return this.names.get(rowIndex);
            }
            assert (false) : columnIndex;
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 1);
            this.names.set(rowIndex, (String)aValue);
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }

    private class AddressElementRenderer
    extends DefaultTableCellRenderer {
        protected void setValue(Object value) {
            super.setValue(value);
            if (value instanceof AddressElement) {
                this.setText(((AddressElement)value).getName());
            }
        }
    }

    private class DatabaseModel
    extends HalfCookedTreeModel {
        private DatabaseModel() {
        }

        public Object getRoot() {
            return CzechAddressPlugin.getLocation();
        }

        public Object getChild(Object parent, int index) {
            if (parent instanceof House) {
                return null;
            }
            if (parent instanceof Street) {
                return ((Street)parent).getHouses().get(index);
            }
            if (parent instanceof Suburb) {
                Suburb suburb = (Suburb)parent;
                if (index < suburb.getHouses().size()) {
                    return suburb.getHouses().get(index);
                }
                if ((index -= suburb.getHouses().size()) < suburb.getStreets().size()) {
                    return suburb.getStreets().get(index);
                }
                return null;
            }
            if (parent instanceof ViToCi) {
                ViToCi vitoci = (ViToCi)parent;
                if (index < vitoci.getHouses().size()) {
                    return vitoci.getHouses().get(index);
                }
                if ((index -= vitoci.getHouses().size()) < vitoci.getStreets().size()) {
                    return vitoci.getStreets().get(index);
                }
                if ((index -= vitoci.getStreets().size()) < vitoci.getSuburbs().size()) {
                    return vitoci.getSuburbs().get(index);
                }
                return null;
            }
            if (parent instanceof Region) {
                Region region = (Region)parent;
                if (index < region.getHouses().size()) {
                    return region.getHouses().get(index);
                }
                if ((index -= region.getHouses().size()) < region.getStreets().size()) {
                    return region.getStreets().get(index);
                }
                if ((index -= region.getStreets().size()) < region.getViToCis().size()) {
                    return region.getViToCis().get(index);
                }
                return null;
            }
            if (parent instanceof Database) {
                return ((Database)parent).regions.get(index);
            }
            return null;
        }

        public int getChildCount(Object parent) {
            if (parent instanceof House) {
                return 0;
            }
            if (parent instanceof Street) {
                return ((Street)parent).getHouses().size();
            }
            if (parent instanceof Suburb) {
                return ((Suburb)parent).getHouses().size() + ((Suburb)parent).getStreets().size();
            }
            if (parent instanceof ViToCi) {
                return ((ViToCi)parent).getHouses().size() + ((ViToCi)parent).getStreets().size() + ((ViToCi)parent).getSuburbs().size();
            }
            if (parent instanceof Region) {
                return ((Region)parent).getHouses().size() + ((Region)parent).getStreets().size() + ((Region)parent).getViToCis().size();
            }
            if (parent instanceof Database) {
                return ((Database)parent).regions.size();
            }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            return 0;
        }
    }
}

