/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.util.List;

public class StringUtils {
    public static boolean isNullOrEmpty(String txt) {
        return txt == null || txt.length() == 0;
    }

    public static int lcsLength(String a, String b) {
        if (StringUtils.isNullOrEmpty(a)) {
            return 0;
        }
        if (StringUtils.isNullOrEmpty(b)) {
            return 0;
        }
        int[][] L = StringUtils.createLCSTable(a, b);
        return L[0][0];
    }

    private static int[][] createLCSTable(String a, String b) {
        int i;
        if (StringUtils.isNullOrEmpty(a)) {
            return null;
        }
        if (StringUtils.isNullOrEmpty(b)) {
            return null;
        }
        int m = a.length();
        int n = b.length();
        int[][] l = new int[m + 1][n + 1];
        for (i = 0; i < l.length; ++i) {
            l[i] = new int[n + 1];
        }
        for (i = m - 1; i >= 0; --i) {
            for (int j = n - 1; j >= 0; --j) {
                l[i][j] = a.charAt(i) == b.charAt(j) ? 1 + l[i + 1][j + 1] : Math.max(l[i + 1][j], l[i][j + 1]);
            }
        }
        return l;
    }

    public static String getLongestCommonSubstring(String a, String b) {
        if (StringUtils.isNullOrEmpty(a)) {
            return null;
        }
        if (StringUtils.isNullOrEmpty(b)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int[][] l = StringUtils.createLCSTable(a, b);
        int m = a.length();
        int n = b.length();
        int i = 0;
        int j = 0;
        while (i < m && j < n) {
            char bb;
            char aa = a.charAt(i);
            if (aa == (bb = b.charAt(j))) {
                sb.append(aa);
                ++i;
                ++j;
                continue;
            }
            if (l[i + 1][j] >= l[i][j + 1]) {
                ++i;
                continue;
            }
            ++j;
        }
        l = null;
        return sb.toString();
    }

    public static String findBestMatch(String needle, List<String> haystack) {
        String bestMatch = null;
        double maxRatio = Double.MIN_VALUE;
        if (StringUtils.isNullOrEmpty(needle)) {
            return null;
        }
        if (haystack == null || haystack.size() == 0) {
            return null;
        }
        int lNeedle = needle.length();
        for (String curString : haystack) {
            int ll = StringUtils.lcsLength(needle, curString);
            double ratio = (double)ll / (double)lNeedle;
            if (!(ratio > maxRatio)) continue;
            maxRatio = ratio;
            bestMatch = curString;
        }
        return bestMatch;
    }
}

