/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipInputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmlReader;

public class KmzReader
extends AbstractReader
implements OdConstants {
    private ZipInputStream zis;

    public KmzReader(ZipInputStream zis) {
        this.zis = zis;
    }

    public static DataSet parseDataSet(InputStream in, ProgressMonitor instance) throws IOException, XMLStreamException, FactoryConfigurationError {
        return new KmzReader(new ZipInputStream(in)).parseDoc(instance);
    }

    private DataSet parseDoc(ProgressMonitor instance) throws IOException, XMLStreamException, FactoryConfigurationError {
        long size = this.zis.getNextEntry().getSize();
        byte[] buffer = new byte[(int)size];
        int off = 0;
        int count = 0;
        while ((count = this.zis.read(buffer, off, (int)size)) > 0) {
            off += count;
            size -= (long)count;
        }
        return KmlReader.parseDataSet(new ByteArrayInputStream(buffer), instance);
    }
}

