/*
 * Decompiled with CFR 0.152.
 */
package mirrored_download;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.Future;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mirrored_download.MirroredDownloadPlugin;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class OverpassDownloadAction
extends JosmAction {
    public OverpassDownloadAction() {
        super(I18n.tr((String)"Download from Overpass API ...", (Object[])new Object[0]), "download_mirror", I18n.tr((String)"Download map data from Overpass API server.", (Object[])new Object[0]), null, true, "overpassdownload/download", true);
        this.putValue("help", HelpUtil.ht((String)"/Action/OverpassDownload"));
    }

    public void actionPerformed(ActionEvent e) {
        OverpassDownloadDialog dialog = OverpassDownloadDialog.getInstance();
        dialog.restoreSettings();
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            dialog.rememberSettings();
            Bounds area = dialog.getSelectedDownloadArea();
            DownloadOsmTask task = new DownloadOsmTask();
            Future future = task.download((OsmServerReader)new OverpassDownloadReader(area, dialog.getOverpassQuery()), dialog.isNewLayerRequired(), area, null);
            Main.worker.submit((Runnable)new PostDownloadHandler((DownloadTask)task, future));
        }
    }

    static class OverpassDownloadReader
    extends BoundingBoxDownloader {
        final String overpassQuery;

        public OverpassDownloadReader(Bounds downloadArea, String overpassQuery) {
            super(downloadArea);
            this.overpassQuery = overpassQuery.trim();
        }

        protected String getBaseUrl() {
            String url = MirroredDownloadPlugin.getDownloadUrl();
            if ("xapi?".equals(url.substring(url.length() - 5, url.length()))) {
                return url.substring(0, url.length() - 5);
            }
            return url;
        }

        protected String getRequestForBbox(double lon1, double lat1, double lon2, double lat2) {
            if (this.overpassQuery.isEmpty()) {
                return "xapi?" + super.getRequestForBbox(lon1, lat1, lon2, lat2);
            }
            String url = "interpreter?data=" + this.overpassQuery + "&bbox=" + lon1 + "," + lat1 + "," + lon2 + "," + lat2;
            try {
                url = "interpreter?data=" + URLEncoder.encode(this.overpassQuery, "UTF-8") + "&bbox=" + lon1 + "," + lat1 + "," + lon2 + "," + lat2;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            return url;
        }

        public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
            DataSet ds = super.parseOsm(progressMonitor);
            if (ds != null && ds.dataSources.isEmpty()) {
                if (this.crosses180th) {
                    Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, 180.0);
                    DataSource src = new DataSource(bounds, MirroredDownloadPlugin.getDownloadUrl());
                    ds.dataSources.add(src);
                    bounds = new Bounds(this.lat1, -180.0, this.lat2, this.lon2);
                    src = new DataSource(bounds, MirroredDownloadPlugin.getDownloadUrl());
                    ds.dataSources.add(src);
                } else {
                    Bounds bounds = new Bounds(this.lat1, this.lon1, this.lat2, this.lon2);
                    DataSource src = new DataSource(bounds, MirroredDownloadPlugin.getDownloadUrl());
                    ds.dataSources.add(src);
                }
            }
            return ds;
        }
    }

    static class OverpassDownloadDialog
    extends DownloadDialog {
        protected JTextArea overpassQuery;
        private static OverpassDownloadDialog instance;

        private OverpassDownloadDialog(Component parent) {
            super(parent);
            this.cbDownloadOsmData.setEnabled(false);
            this.cbDownloadGpxData.setEnabled(false);
            this.cbStartup.setEnabled(false);
        }

        public static OverpassDownloadDialog getInstance() {
            if (instance == null) {
                instance = new OverpassDownloadDialog(Main.parent);
            }
            return instance;
        }

        protected void buildMainPanelAboveDownloadSelections(JPanel pnl) {
            this.overpassQuery = new JTextArea("[timeout:15];", 8, 80);
            pnl.add((Component)new JLabel(I18n.tr((String)"Overpass query: ", (Object[])new Object[0])), GBC.std().insets(5, 5, 5, 5));
            pnl.add((Component)new JScrollPane(this.overpassQuery), GBC.eol().fill(1));
        }

        public String getOverpassQuery() {
            return this.overpassQuery.getText();
        }
    }
}

