/*
 * Decompiled with CFR 0.152.
 */
package pdfimport.pdfbox;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.apache.pdfbox.util.ResourceLoader;
import org.apache.pdfbox.util.TextPosition;
import pdfimport.pdfbox.GraphicsProcessor;

public class PageDrawer
extends PDFStreamEngine {
    private GraphicsProcessor graphics;
    private BasicStroke stroke;
    protected PDPage page;
    private final GeneralPath linePath = new GeneralPath();

    public PageDrawer() throws IOException {
        super(ResourceLoader.loadProperties("pdfimport/pdfbox/PageDrawer.properties", true));
    }

    public void drawPage(GraphicsProcessor g, PDPage p) throws IOException {
        this.graphics = g;
        this.page = p;
        if (this.page.getContents() != null) {
            PDResources resources = this.page.findResources();
            this.processStream(this.page, resources, this.page.getContents().getStream());
        }
        List annotations = this.page.getAnnotations();
        for (int i = 0; i < annotations.size(); ++i) {
            PDAppearanceStream appearance;
            Map appearanceMap;
            PDAnnotation annot = (PDAnnotation)annotations.get(i);
            PDRectangle rect = annot.getRectangle();
            String appearanceName = annot.getAppearanceStream();
            PDAppearanceDictionary appearDictionary = annot.getAppearance();
            if (appearDictionary == null) continue;
            if (appearanceName == null) {
                appearanceName = "default";
            }
            if ((appearanceMap = appearDictionary.getNormalAppearance()) == null || (appearance = (PDAppearanceStream)appearanceMap.get(appearanceName)) == null) continue;
            this.processSubStream(this.page, appearance.getResources(), appearance.getStream());
        }
    }

    @Override
    protected void processTextPosition(TextPosition text) {
        Color color = null;
        try {
            switch (this.getGraphicsState().getTextState().getRenderingMode()) {
                case 0: {
                    color = this.getGraphicsState().getNonStrokingColor().getJavaColor();
                    break;
                }
                case 1: {
                    color = this.getGraphicsState().getStrokingColor().getJavaColor();
                    break;
                }
                case 3: {
                    Color nsc = this.getGraphicsState().getStrokingColor().getJavaColor();
                    float[] components = new float[]{Color.black.getRed(), Color.black.getGreen(), Color.black.getBlue()};
                    color = new Color(nsc.getColorSpace(), components, 0.0f);
                    break;
                }
                default: {
                    color = this.getGraphicsState().getNonStrokingColor().getJavaColor();
                }
            }
            Matrix textPos = text.getTextPos().copy();
            float x = textPos.getXPosition();
            float y = textPos.getYPosition();
            this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
            this.graphics.drawString(x, y, text.getCharacter(), color);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public PDPage getPage() {
        return this.page;
    }

    public GeneralPath getLinePath() {
        return this.linePath;
    }

    public void setStroke(BasicStroke newStroke) {
        this.stroke = newStroke;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void drawPath(boolean stroke, boolean fill, int windingRule) throws IOException {
        this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
        GeneralPath path = this.getLinePath();
        Color strokeColor = this.getGraphicsState().getStrokingColor().getJavaColor();
        Color fillColor = this.getGraphicsState().getNonStrokingColor().getJavaColor();
        this.graphics.drawPath(path, stroke ? strokeColor : null, fill ? fillColor : null, windingRule);
        path.reset();
    }

    public void drawImage() {
        this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
        this.graphics.drawImage();
    }

    public void SHFill(COSName ShadingName) throws IOException {
        this.drawPath(false, true, 1);
    }

    public Point2D.Double transformedPoint(double x, double y) {
        double[] position = new double[]{x, y};
        this.getGraphicsState().getCurrentTransformationMatrix().createAffineTransform().transform(position, 0, position, 0, 1);
        return new Point2D.Double(position[0], position[1]);
    }

    public void setClippingPath(int windingRule) {
        PDGraphicsState graphicsState = this.getGraphicsState();
        GeneralPath clippingPath = (GeneralPath)this.getLinePath().clone();
        clippingPath.setWindingRule(windingRule);
        if (graphicsState.getCurrentClippingPath() != null) {
            Area currentArea = new Area(this.getGraphicsState().getCurrentClippingPath());
            Area newArea = new Area(clippingPath);
            currentArea.intersect(newArea);
            graphicsState.setCurrentClippingPath(currentArea);
        } else {
            graphicsState.setCurrentClippingPath(clippingPath);
        }
        this.getLinePath().reset();
    }
}

