/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.manual;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.tools.I18n;

public class ManualCalibration
extends JFrame
implements ActionListener {
    private JTextField[][] values;
    private double[][] result;
    private static final int FIELD_WIDTH = 80;

    public ManualCalibration() {
        this.addControls();
    }

    private void addControls() {
        JPanel panel = new JPanel();
        this.getContentPane().add(panel);
        panel.setLayout(null);
        JLabel label = new JLabel(I18n.tr((String)"Point {0}", (Object[])new Object[]{1}));
        label.setBounds(10, 30, 50, 20);
        panel.add(label);
        label = new JLabel(I18n.tr((String)"Point {0}", (Object[])new Object[]{2}));
        label.setBounds(10, 50, 50, 20);
        panel.add(label);
        label = new JLabel(I18n.tr((String)"Point {0}", (Object[])new Object[]{3}));
        label.setBounds(10, 70, 50, 20);
        panel.add(label);
        label = new JLabel(I18n.tr((String)"Picture X", (Object[])new Object[0]));
        label.setBounds(60, 10, 80, 20);
        panel.add(label);
        label = new JLabel(I18n.tr((String)"Picture Y", (Object[])new Object[0]));
        label.setBounds(140, 10, 80, 20);
        panel.add(label);
        label = new JLabel(I18n.tr((String)"Latitude", (Object[])new Object[0]));
        label.setBounds(220, 10, 80, 20);
        panel.add(label);
        label = new JLabel(I18n.tr((String)"Longtitude", (Object[])new Object[0]));
        label.setBounds(300, 10, 80, 20);
        panel.add(label);
        this.values = new JTextField[3][];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new JTextField[4];
            JTextField[] value = this.values[i];
            for (int j = 0; j < value.length; ++j) {
                JTextField field = value[j] = new JTextField();
                field.setBounds(60 + j * 80, 30 + i * 20, 80, 20);
                panel.add(field);
            }
        }
        JButton btn = new JButton(I18n.tr((String)"Apply", (Object[])new Object[0]));
        btn.setBounds(90, 100, 100, 20);
        btn.addActionListener(this);
        panel.add(btn);
        btn = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]));
        btn.setBounds(210, 100, 100, 20);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualCalibration.access$002(ManualCalibration.this, null);
                ManualCalibration.this.close();
            }
        });
        panel.add(btn);
        this.setTitle(I18n.tr((String)"Specify calibration points", (Object[])new Object[0]));
        this.setSize(410, 180);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int i;
        if (this.result == null) {
            this.result = new double[3][];
            for (i = 0; i < this.result.length; ++i) {
                this.result[i] = new double[4];
            }
        }
        for (i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                JTextField field = this.values[i][j];
                String text = field.getText();
                double val = 0.0;
                try {
                    val = j > 1 ? Double.parseDouble(text) : (double)Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    field.requestFocus();
                    field.selectAll();
                    JOptionPane.showMessageDialog(this, I18n.tr((String)"Number format is invalid", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                    return;
                }
                this.result[i][j] = val;
            }
        }
        this.close();
    }

    public double[][] getResult() {
        return this.result;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        ManualCalibration c = new ManualCalibration();
        c.setVisible(true);
    }

    static /* synthetic */ double[][] access$002(ManualCalibration x0, double[][] x1) {
        x0.result = x1;
        return x1;
    }
}

