/*
 * Decompiled with CFR 0.152.
 */
package geochat;

import geochat.JsonQueryCallback;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.openstreetmap.josm.Main;

public class JsonQueryUtil
implements Runnable {
    private String query;
    private JsonQueryCallback callback;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject query(String query) throws IOException {
        try {
            String serverURL = Main.pref.get("geochat.server", "http://zverik.dev.openstreetmap.org/osmochat.php?action=");
            URL url = new URL(serverURL + query);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            if (connection.getResponseCode() != 200) {
                throw new IOException("HTTP Response code " + connection.getResponseCode() + " (" + connection.getResponseMessage() + ")");
            }
            InputStream inp = connection.getInputStream();
            if (inp == null) {
                throw new IOException("Empty response");
            }
            try {
                JSONObject result;
                JSONTokener tokener = new JSONTokener(inp);
                JSONObject jSONObject = result = new JSONObject(tokener);
                return jSONObject;
            }
            catch (JSONException e) {
                throw new IOException("Failed to parse JSON: " + e.getMessage());
            }
            finally {
                connection.disconnect();
            }
        }
        catch (MalformedURLException ex) {
            throw new IOException("Malformed URL: " + ex.getMessage());
        }
    }

    private JsonQueryUtil() {
    }

    private JsonQueryUtil(String query, JsonQueryCallback callback) {
        this.query = query;
        this.callback = callback;
    }

    public static void queryAsync(String query, JsonQueryCallback callback) {
        Main.worker.submit(new JsonQueryUtil(query, callback));
    }

    private void doRealRun() {
        JSONObject obj;
        try {
            obj = JsonQueryUtil.query(this.query);
        }
        catch (IOException e) {
            Main.warn((String)(e.getClass().getName() + " while connecting to a chat server: " + e.getMessage()));
            obj = null;
        }
        if (this.callback != null) {
            this.callback.processJson(obj);
        }
    }

    @Override
    public void run() {
        if (EventQueue.isDispatchThread()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JsonQueryUtil.this.doRealRun();
                }
            }).start();
        } else {
            this.doRealRun();
        }
    }
}

