/*
 * Decompiled with CFR 0.152.
 */
package geochat;

import java.awt.event.KeyEvent;
import java.util.HashSet;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;

public class JPanelTextField
extends JTextField {
    public JPanelTextField() {
        this.setFocusTraversalKeys(0, new HashSet());
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            int code = e.getKeyCode();
            if (code == 10) {
                String text = this.getText();
                if (text.length() > 0) {
                    this.processEnter(text);
                    this.setText("");
                }
            } else if (code == 9) {
                int start;
                String text = this.getText();
                int caret = this.getCaretPosition();
                for (start = caret - 1; start >= 0 && Character.isJavaIdentifierPart(text.charAt(start)); --start) {
                }
                if (++start < caret) {
                    String complete;
                    String word = text.substring(start, caret);
                    String string = word == null ? null : (complete = this.autoComplete(word, start == 0));
                    if (complete != null && !complete.equals(word)) {
                        StringBuilder sb = new StringBuilder();
                        if (start > 0) {
                            sb.append(text.substring(0, start));
                        }
                        sb.append(complete);
                        if (caret < text.length()) {
                            sb.append(text.substring(caret));
                        }
                        this.setText(sb.toString());
                        this.setCaretPosition(start + complete.length());
                    }
                }
            } else if (code == 27 && Main.map != null && Main.map.mapView != null) {
                Main.map.mapView.requestFocus();
            }
            if (code != 37 && code != 36 && code != 39 && code != 35 && code != 8 && code != 127) {
                e.consume();
            }
        }
        super.processKeyEvent(e);
    }

    protected void processEnter(String text) {
    }

    protected String autoComplete(String word, boolean atStart) {
        return word;
    }
}

