/*
 * Decompiled with CFR 0.152.
 */
package geochat;

import geochat.ChatMessage;
import geochat.ChatPaneManager;
import geochat.ChatServerConnection;
import geochat.ChatServerConnectionListener;
import geochat.GeoChatPopupAdapter;
import geochat.JPanelTextField;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class GeoChatPanel
extends ToggleDialog
implements ChatServerConnectionListener,
MapViewPaintable {
    private JTextField input;
    private JTabbedPane tabs;
    private JComponent noData;
    private JPanel loginPanel;
    private JPanel gcPanel;
    private ChatServerConnection connection;
    protected Map<String, LatLon> users;
    protected ChatPaneManager chatPanes;
    protected boolean userLayerActive;
    private final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm");

    public GeoChatPanel() {
        super(I18n.tr((String)"GeoChat", (Object[])new Object[0]), "geochat", I18n.tr((String)"Open GeoChat panel", (Object[])new Object[0]), null, 200, true);
        this.noData = new JLabel(I18n.tr((String)"Zoom in to see messages", (Object[])new Object[0]), 0);
        this.tabs = new JTabbedPane();
        this.tabs.addMouseListener(new GeoChatPopupAdapter(this));
        this.chatPanes = new ChatPaneManager(this, this.tabs);
        this.input = new JPanelTextField(){

            @Override
            protected void processEnter(String text) {
                GeoChatPanel.this.connection.postMessage(text, GeoChatPanel.this.chatPanes.getRecipient());
            }

            @Override
            protected String autoComplete(String word, boolean atStart) {
                return GeoChatPanel.this.autoCompleteUser(word, atStart);
            }
        };
        this.loginPanel = this.createLoginPanel();
        this.gcPanel = new JPanel(new BorderLayout());
        this.gcPanel.add((Component)this.loginPanel, "Center");
        this.createLayout(this.gcPanel, false, null);
        this.users = new TreeMap<String, LatLon>();
        this.connection = ChatServerConnection.getInstance();
        this.connection.addListener(this);
        this.connection.checkLogin();
    }

    private JPanel createLoginPanel() {
        final JPanelTextField nameField = new JPanelTextField(){

            @Override
            protected void processEnter(String text) {
                GeoChatPanel.this.connection.login(text);
            }
        };
        String userName = JosmUserIdentityManager.getInstance().getUserName();
        if (userName == null) {
            userName = "";
        }
        if (userName.contains("@")) {
            userName = userName.substring(0, userName.indexOf(64));
        }
        userName = userName.replace(' ', '_');
        nameField.setText(userName);
        JButton loginButton = new JButton(I18n.tr((String)"Login", (Object[])new Object[0]));
        loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeoChatPanel.this.connection.login(nameField.getText());
            }
        });
        nameField.setPreferredSize(new Dimension(nameField.getPreferredSize().width, loginButton.getPreferredSize().height));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)nameField, GBC.std().fill(2).insets(15, 0, 5, 0));
        panel.add((Component)loginButton, GBC.std().fill(0).insets(0, 0, 15, 0));
        return panel;
    }

    protected void logout() {
        this.connection.logout();
    }

    public void destroy() {
        try {
            if (Main.pref.getBoolean("geochat.logout.on.close", true)) {
                this.connection.removeListener(this);
                this.connection.bruteLogout();
            }
        }
        catch (Throwable e) {
            Main.warn((String)("Failed to logout from geochat server: " + e.getMessage()));
        }
        super.destroy();
    }

    private String autoCompleteUser(String word, boolean atStart) {
        String result = null;
        boolean singleUser = true;
        for (String user : this.users.keySet()) {
            int i;
            if (!user.startsWith(word)) continue;
            if (result == null) {
                result = user;
                continue;
            }
            singleUser = false;
            for (i = word.length(); i < result.length() && i < user.length() && result.charAt(i) == user.charAt(i); ++i) {
            }
            if (i >= result.length()) continue;
            result = result.substring(0, i);
        }
        return result == null ? null : (!singleUser ? result : (atStart ? result + ": " : result + " "));
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(Color.yellow);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.3f));
        int zoom = ChatServerConnection.getCurrentZoom();
        int radius = Math.max(zoom, 1) * 10;
        if (zoom < 14) {
            radius /= 2;
        }
        Font font = g2d.getFont().deriveFont(1, Math.max(zoom * 2, 8));
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        for (String user : this.users.keySet()) {
            Point p = mv.getPoint(this.users.get(user));
            g2d.setColor(Color.yellow);
            g2d.fillOval(p.x - radius, p.y - radius, radius * 2 + 1, radius * 2 + 1);
            g2d.setColor(Color.black);
            Rectangle2D rect = fm.getStringBounds(user, g2d);
            g2d.drawString(user, (float)((long)p.x - Math.round(rect.getWidth() / 2.0)), (float)p.y);
        }
    }

    protected void updateTitleAlarm() {
        String title;
        int alarmLevel = this.chatPanes.getNotifyLevel();
        if (!this.isDialogInCollapsedView() && alarmLevel > 1) {
            alarmLevel = 1;
        }
        String string = title = this.users.isEmpty() ? I18n.tr((String)"GeoChat", (Object[])new Object[0]) : I18n.trn((String)"GeoChat ({0} user)", (String)"GeoChat ({0} users)", (long)this.users.size(), (Object[])new Object[]{this.users.size()});
        String alarm = alarmLevel <= 0 ? "" : (alarmLevel == 1 ? "* " : "!!! ");
        this.setTitle(alarm + title);
    }

    protected void setIsCollapsed(boolean val) {
        super.setIsCollapsed(val);
        this.chatPanes.setCollapsed(val);
        this.updateTitleAlarm();
    }

    @Override
    public void loggedIn(String userName) {
        if (this.gcPanel.getComponentCount() == 1) {
            this.gcPanel.remove(0);
            this.gcPanel.add((Component)this.tabs, "Center");
            this.gcPanel.add((Component)this.input, "South");
        }
    }

    @Override
    public void notLoggedIn(final String reason) {
        if (reason != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(Main.parent, reason);
                }
            });
        } else if (this.gcPanel.getComponentCount() > 1) {
            this.gcPanel.removeAll();
            this.gcPanel.add((Component)this.loginPanel, "Center");
        }
    }

    @Override
    public void messageSendFailed(final String reason) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(Main.parent, reason);
            }
        });
    }

    @Override
    public void statusChanged(boolean active) {
        this.tabs.setComponentAt(0, active ? this.chatPanes.getPublicChatComponent() : this.noData);
        this.repaint();
    }

    @Override
    public void updateUsers(Map<String, LatLon> newUsers) {
        for (String uname : this.users.keySet()) {
            if (newUsers.containsKey(uname)) continue;
            this.chatPanes.addLineToPublic(I18n.tr((String)"User {0} has left", (Object[])new Object[]{uname}), ChatPaneManager.MESSAGE_TYPE_INFORMATION);
        }
        for (String uname : newUsers.keySet()) {
            if (this.users.containsKey(uname)) continue;
            this.chatPanes.addLineToPublic(I18n.tr((String)"User {0} is mapping nearby", (Object[])new Object[]{uname}), ChatPaneManager.MESSAGE_TYPE_INFORMATION);
        }
        this.users = newUsers;
        this.updateTitleAlarm();
        if (this.userLayerActive && Main.map.mapView != null) {
            Main.map.mapView.repaint();
        }
    }

    private void formatMessage(StringBuilder sb, ChatMessage msg) {
        sb.append("\n");
        sb.append('[').append(this.TIME_FORMAT.format(msg.getTime())).append("] ");
        sb.append(msg.getAuthor()).append(": ").append(msg.getMessage());
    }

    @Override
    public void receivedMessages(boolean replace, List<ChatMessage> messages) {
        if (replace) {
            this.chatPanes.clearPublicChatPane();
        }
        if (!messages.isEmpty()) {
            int alarm = 0;
            StringBuilder sb = new StringBuilder();
            for (ChatMessage msg : messages) {
                boolean important;
                boolean bl = important = msg.isIncoming() && this.containsName(msg.getMessage());
                if (msg.isIncoming() && alarm < 2) {
                    int n = alarm = important ? 2 : 1;
                }
                if (important) {
                    this.chatPanes.addLineToPublic(sb.toString());
                    sb.setLength(0);
                    this.formatMessage(sb, msg);
                    this.chatPanes.addLineToPublic(sb.toString(), ChatPaneManager.MESSAGE_TYPE_ATTENTION);
                    sb.setLength(0);
                    continue;
                }
                this.formatMessage(sb, msg);
            }
            this.chatPanes.addLineToPublic(sb.toString());
            if (alarm > 0) {
                this.chatPanes.notify(null, alarm);
            }
        }
        if (replace) {
            this.showNearbyUsers();
        }
    }

    private void showNearbyUsers() {
        if (!this.users.isEmpty()) {
            StringBuilder sb = new StringBuilder(I18n.tr((String)"Users mapping nearby:", (Object[])new Object[0]));
            boolean first = true;
            for (String user : this.users.keySet()) {
                sb.append(first ? " " : ", ");
                sb.append(user);
            }
            this.chatPanes.addLineToPublic(sb.toString(), ChatPaneManager.MESSAGE_TYPE_INFORMATION);
        }
    }

    private boolean containsName(String message) {
        String userName = this.connection.getUserName();
        int length = userName.length();
        int i = message.indexOf(userName);
        while (i >= 0) {
            if (!(i != 0 && Character.isJavaIdentifierPart(message.charAt(i - 1)) || i + length < message.length() && Character.isJavaIdentifierPart(message.charAt(i + length)))) {
                return true;
            }
            i = message.indexOf(userName, i + 1);
        }
        return false;
    }

    @Override
    public void receivedPrivateMessages(boolean replace, List<ChatMessage> messages) {
        if (replace) {
            this.chatPanes.closePrivateChatPanes();
        }
        for (ChatMessage msg : messages) {
            StringBuilder sb = new StringBuilder();
            this.formatMessage(sb, msg);
            this.chatPanes.addLineToChatPane(msg.isIncoming() ? msg.getAuthor() : msg.getRecipient(), sb.toString());
            if (!msg.isIncoming()) continue;
            this.chatPanes.notify(msg.getAuthor(), 2);
        }
    }
}

