/*
 * Decompiled with CFR 0.152.
 */
package geochat;

import geochat.GeoChatPanel;
import geochat.GeoChatPopupAdapter;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.openstreetmap.josm.tools.I18n;

class ChatPaneManager {
    private static final String PUBLIC_PANE = "Public Pane";
    private GeoChatPanel panel;
    private JTabbedPane tabs;
    private Map<String, ChatPane> chatPanes;
    private boolean collapsed;

    public ChatPaneManager(GeoChatPanel panel, JTabbedPane tabs) {
        this.panel = panel;
        this.tabs = tabs;
        this.collapsed = panel.isDialogInCollapsedView();
        this.chatPanes = new HashMap<String, ChatPane>();
        this.createChatPane(null);
        tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ChatPaneManager.this.updateActiveTabStatus();
            }
        });
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
        this.updateActiveTabStatus();
    }

    public boolean hasUser(String user) {
        return this.chatPanes.containsKey(user == null ? PUBLIC_PANE : user);
    }

    public Component getPublicChatComponent() {
        return this.chatPanes.get((Object)PUBLIC_PANE).component;
    }

    public int getNotifyLevel() {
        int alarm = 0;
        for (ChatPane entry : this.chatPanes.values()) {
            if (entry.notify <= alarm) continue;
            alarm = entry.notify;
        }
        return alarm;
    }

    public void updateActiveTabStatus() {
        if (this.tabs.getSelectedIndex() >= 0) {
            ((ChatTabTitleComponent)this.tabs.getTabComponentAt(this.tabs.getSelectedIndex())).updateAlarm();
        }
    }

    public void notify(String user, int alarmLevel) {
        if (alarmLevel <= 0 || !this.hasUser(user)) {
            return;
        }
        ChatPane entry = this.chatPanes.get(user == null ? PUBLIC_PANE : user);
        entry.notify = alarmLevel;
        int idx = this.tabs.indexOfComponent(entry.component);
        if (idx >= 0) {
            ((ChatTabTitleComponent)this.tabs.getTabComponentAt(idx)).updateAlarm();
        }
    }

    public void addLineToChatPane(String userName, String line) {
        if (line.length() == 0) {
            return;
        }
        if (!this.chatPanes.containsKey(userName)) {
            this.createChatPane(userName);
        }
        if (!line.startsWith("\n")) {
            line = "\n" + line;
        }
        Document doc = this.chatPanes.get((Object)userName).pane.getDocument();
        try {
            doc.insertString(doc.getLength(), line, null);
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
    }

    public void addLineToPublic(String line) {
        this.addLineToChatPane(PUBLIC_PANE, line);
    }

    public void addLineToPublicEm(String line) {
        if (!line.startsWith("\n")) {
            line = "\n" + line;
        }
        Document doc = this.chatPanes.get((Object)PUBLIC_PANE).pane.getDocument();
        try {
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            StyleConstants.setItalic(attrs, true);
            doc.insertString(doc.getLength(), line, attrs);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void clearPublicChatPane() {
        this.chatPanes.get((Object)PUBLIC_PANE).pane.setText("");
        this.showNearbyUsers();
    }

    private void showNearbyUsers() {
        if (!this.panel.users.isEmpty()) {
            StringBuilder sb = new StringBuilder(I18n.tr((String)"Users mapping nearby:", (Object[])new Object[0]));
            boolean first = true;
            for (String user : this.panel.users.keySet()) {
                sb.append(first ? " " : ", ");
                sb.append(user);
            }
            this.addLineToPublic(sb.toString());
        }
    }

    public void clearChatPane(String userName) {
        if (userName == null || userName.equals(PUBLIC_PANE)) {
            this.clearPublicChatPane();
        } else {
            this.chatPanes.get((Object)userName).pane.setText("");
        }
    }

    public void clearActiveChatPane() {
        this.clearChatPane(this.getActiveChatPane());
    }

    public ChatPane createChatPane(String userName) {
        JTextPane chatPane = new JTextPane();
        chatPane.setEditable(false);
        Font font = chatPane.getFont();
        chatPane.setFont(font.deriveFont(font.getSize2D() - 2.0f));
        DefaultCaret caret = (DefaultCaret)chatPane.getCaret();
        caret.setUpdatePolicy(2);
        JScrollPane scrollPane = new JScrollPane(chatPane, 22, 31);
        chatPane.addMouseListener(new GeoChatPopupAdapter(this.panel));
        ChatPane entry = new ChatPane();
        entry.pane = chatPane;
        entry.component = scrollPane;
        entry.notify = 0;
        entry.userName = userName;
        entry.isPublic = userName == null;
        this.chatPanes.put(userName == null ? PUBLIC_PANE : userName, entry);
        this.tabs.addTab(null, scrollPane);
        this.tabs.setTabComponentAt(this.tabs.getTabCount() - 1, new ChatTabTitleComponent(entry));
        this.tabs.setSelectedComponent(scrollPane);
        return entry;
    }

    public String getActiveChatPane() {
        Component c = this.tabs.getSelectedComponent();
        if (c == null) {
            return null;
        }
        for (String user : this.chatPanes.keySet()) {
            if (!c.equals(this.chatPanes.get((Object)user).component)) continue;
            return user;
        }
        return null;
    }

    public String getRecipient() {
        String user = this.getActiveChatPane();
        return user == null || user.equals(PUBLIC_PANE) ? null : user;
    }

    public void closeChatPane(String user) {
        if (user == null || user.equals(PUBLIC_PANE) || !this.chatPanes.containsKey(user)) {
            return;
        }
        this.tabs.remove(this.chatPanes.get((Object)user).component);
        this.chatPanes.remove(user);
    }

    public void closeSelectedPrivatePane() {
        String pane = this.getRecipient();
        if (pane != null) {
            this.closeChatPane(pane);
        }
    }

    public void closePrivateChatPanes() {
        ArrayList<String> entries = new ArrayList<String>(this.chatPanes.keySet());
        for (String user : entries) {
            if (user.equals(PUBLIC_PANE)) continue;
            this.closeChatPane(user);
        }
    }

    class ChatPane {
        public String userName;
        public boolean isPublic;
        public JTextPane pane;
        public JScrollPane component;
        public int notify;

        ChatPane() {
        }
    }

    private class ChatTabTitleComponent
    extends JLabel {
        private ChatPane entry;
        private Font normalFont;
        private Font boldFont;

        public ChatTabTitleComponent(ChatPane entry) {
            super(entry.isPublic ? I18n.tr((String)"Public", (Object[])new Object[0]) : entry.userName);
            this.entry = entry;
        }

        public void updateAlarm() {
            if (this.normalFont == null) {
                this.normalFont = this.getFont().deriveFont(0);
                this.boldFont = this.getFont().deriveFont(1);
            }
            if (this.entry.notify > 0 && !ChatPaneManager.this.collapsed && ChatPaneManager.this.tabs.getSelectedIndex() == ChatPaneManager.this.tabs.indexOfComponent(this.entry.component)) {
                this.entry.notify = 0;
            }
            this.setFont(this.entry.notify > 0 ? this.boldFont : this.normalFont);
            ChatPaneManager.this.panel.updateTitleAlarm();
        }
    }
}

