/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.runtime.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.runtime.install.NativeLibraryManagerEventListener;

public class NativeLibraryManager {
    private static final String PACKAGE_RESOURCE_DIRECTORY = "vlc/";
    private static final int IO_BUFFER_SIZE = 2048;
    private final String installTo;
    private final int ioBufferSize;
    private final List<NativeLibraryManagerEventListener> listeners = new ArrayList<NativeLibraryManagerEventListener>(1);

    public NativeLibraryManager(String installTo) {
        this(installTo, 2048);
    }

    public NativeLibraryManager(String installTo, int ioBufferSize) {
        this.installTo = installTo;
        this.ioBufferSize = ioBufferSize;
    }

    public void addEventListener(NativeLibraryManagerEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(NativeLibraryManagerEventListener listener) {
        this.listeners.remove(listener);
    }

    public String getInstallTo() {
        return this.installTo;
    }

    public void unpackNativePackage() {
        Logger.debug("unpackNativePackage()", new Object[0]);
        File installDirectory = new File(this.installTo);
        Logger.debug("installDirectory={}", installDirectory);
        String osName = System.getProperty("os.name");
        Logger.debug("osName={}", osName);
        String osArch = System.getProperty("os.arch");
        Logger.debug("osArch={}", osArch);
        String platformResources = String.format("%s%s-%s/", PACKAGE_RESOURCE_DIRECTORY, osName, osArch).toLowerCase();
        Logger.debug("platformResources={}", platformResources);
        JarFile jarFile = this.getNativePackageJarFile(platformResources);
        Logger.debug("jarFile={}", jarFile);
        int installCount = this.getInstallCount(jarFile);
        Logger.debug("installCount={}", installCount);
        this.fireStartEvent(installCount);
        byte[] ioBuffer = new byte[this.ioBufferSize];
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        jarEntries = jarFile.entries();
        int n = 0;
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory() || !jarEntry.getName().startsWith(platformResources)) continue;
            String entryName = jarEntry.getName().substring(platformResources.length());
            this.fireInstallEvent(++n, entryName);
            this.processNativeResource(installDirectory, entryName, jarFile, jarEntry, ioBuffer);
        }
        this.fireEndEvent();
    }

    public boolean purge() {
        Logger.debug("purge()", new Object[0]);
        this.firePurgeEvent();
        boolean result = this.purge(new File(this.installTo), true);
        this.firePurgedEvent(result);
        return result;
    }

    private JarFile getNativePackageJarFile(String resourcePath) {
        URLConnection urlConnection;
        Logger.debug("getNativePackageJarFile()", new Object[0]);
        URL vlcPluginsUrl = NativeLibraryManager.class.getClassLoader().getResource(resourcePath);
        Logger.debug("vlcPluginsUrl={}", vlcPluginsUrl);
        if (vlcPluginsUrl == null) {
            throw new RuntimeException("Failed to find a native library resource on the class-path");
        }
        try {
            urlConnection = vlcPluginsUrl.openConnection();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open a the native library class-path resource");
        }
        if (!(urlConnection instanceof JarURLConnection)) {
            throw new RuntimeException("Expected the native library resources to be contained in a jar file");
        }
        try {
            return ((JarURLConnection)urlConnection).getJarFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the native library class-path resource jar file");
        }
    }

    private int getInstallCount(JarFile jarFile) {
        Logger.debug("getInstallCount()", new Object[0]);
        int count = 0;
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().startsWith(PACKAGE_RESOURCE_DIRECTORY)) continue;
            ++count;
        }
        return count;
    }

    private void processNativeResource(File installDirectory, String entryName, JarFile jarFile, JarEntry jarEntry, byte[] ioBuffer) {
        Logger.trace("processNativeResource(entryName={})", entryName);
        File installFile = new File(installDirectory, entryName);
        File parentDirectory = installFile.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists() && !parentDirectory.mkdirs()) {
            Logger.error("Failed to create installation directory '{}'", installFile.getAbsolutePath());
            throw new RuntimeException("Failed to create installation directory '" + installFile.getAbsolutePath() + "'");
        }
        this.storeResource(installFile, jarFile, jarEntry, ioBuffer);
    }

    private void storeResource(File installFile, JarFile jarFile, JarEntry jarEntry, byte[] ioBuffer) {
        Logger.trace("storeResource(installFile={},jarEntry={}", installFile, jarEntry);
        InputStream in = null;
        OutputStream out = null;
        try {
            int read;
            in = jarFile.getInputStream(jarEntry);
            out = new FileOutputStream(installFile);
            while ((read = in.read(ioBuffer)) != -1) {
                out.write(ioBuffer, 0, read);
            }
        }
        catch (IOException e) {
            Logger.error("Failed to install file '{}' because: {}", installFile, e.getMessage());
            throw new RuntimeException("Failed to install file '" + installFile + "'", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private boolean purge(File file, boolean result) {
        Logger.trace("purge(file={})", file);
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                result = this.purge(child, result);
            }
        }
        return file.delete() && result;
    }

    private void fireStartEvent(int installCount) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).start(this.installTo, installCount);
        }
    }

    private void fireInstallEvent(int number, String name) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).install(number, name);
        }
    }

    private void fireEndEvent() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).end();
        }
    }

    private void firePurgeEvent() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).purge(this.installTo);
        }
    }

    private void firePurgedEvent(boolean result) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).purged(result);
        }
    }
}

