/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.filter;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public abstract class ExtensionFileFilter
implements FileFilter {
    private final String[] extensions;
    private final Set<String> extensionsSet = new HashSet<String>();

    protected ExtensionFileFilter(String[] extensions) {
        this.extensions = Arrays.copyOf(extensions, extensions.length);
        Arrays.sort(this.extensions);
        for (String extension : extensions) {
            this.extensionsSet.add(extension);
        }
    }

    public String[] getExtensions() {
        return Arrays.copyOf(this.extensions, this.extensions.length);
    }

    public Set<String> getExtensionSet() {
        return new TreeSet<String>(this.extensionsSet);
    }

    @Override
    public boolean accept(File pathname) {
        String name;
        int dot;
        if (pathname.isFile() && (dot = (name = pathname.getName()).lastIndexOf(46)) != -1 && dot + 1 < name.length()) {
            String extension = name.substring(dot + 1);
            return this.extensionsSet.contains(extension);
        }
        return false;
    }
}

