/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;
import org.openstreetmap.josm.plugins.piclayer.transform.NoSolutionException;
import org.openstreetmap.josm.plugins.piclayer.transform.PictureTransform;

class Matrix3D {
    double[][] a = new double[3][];

    public Matrix3D() {
        this.a[0] = new double[3];
        this.a[1] = new double[3];
        this.a[2] = new double[3];
    }

    public Matrix3D(PictureTransform pictureTransform, double b11, double b12, double b13, double b21, double b22, double b23, double b31, double b32, double b33) {
        this();
        this.a[0][0] = b11;
        this.a[0][1] = b12;
        this.a[0][2] = b13;
        this.a[1][0] = b21;
        this.a[1][1] = b22;
        this.a[1][2] = b23;
        this.a[2][0] = b31;
        this.a[2][1] = b32;
        this.a[2][2] = b33;
    }

    public Matrix3D(List<? extends Point2D> list) {
        this();
        int i = 0;
        while (i < 3) {
            Point2D p = list.get(i);
            this.a[0][i] = p.getX();
            this.a[1][i] = p.getY();
            this.a[2][i] = 1.0;
            ++i;
        }
    }

    public Matrix3D multiply(Matrix3D m) {
        Matrix3D result = new Matrix3D();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                double sum = 0.0;
                int k = 0;
                while (k < 3) {
                    sum += this.a[i][k] * m.a[k][j];
                    ++k;
                }
                result.a[i][j] = sum;
                ++j;
            }
            ++i;
        }
        return result;
    }

    private double determinant() {
        return this.a[0][0] * (this.a[1][1] * this.a[2][2] - this.a[1][2] * this.a[2][1]) - this.a[0][1] * (this.a[1][0] * this.a[2][2] - this.a[1][2] * this.a[2][0]) + this.a[0][2] * (this.a[1][0] * this.a[2][1] - this.a[1][1] * this.a[2][0]);
    }

    public Matrix3D inverse() throws NoSolutionException {
        Matrix3D invert = new Matrix3D();
        double det = this.determinant();
        if (Math.abs(det) <= Double.MIN_VALUE) {
            throw new NoSolutionException("Determinant = 0");
        }
        double s = 1.0 / det;
        invert.a[0][0] = s * (this.a[1][1] * this.a[2][2] - this.a[1][2] * this.a[2][1]);
        invert.a[1][0] = s * (this.a[1][2] * this.a[2][0] - this.a[1][0] * this.a[2][2]);
        invert.a[2][0] = s * (this.a[1][0] * this.a[2][1] - this.a[1][1] * this.a[2][0]);
        invert.a[0][1] = s * (this.a[0][2] * this.a[2][1] - this.a[0][1] * this.a[2][2]);
        invert.a[1][1] = s * (this.a[0][0] * this.a[2][2] - this.a[0][2] * this.a[2][0]);
        invert.a[2][1] = s * (this.a[0][1] * this.a[2][0] - this.a[0][0] * this.a[2][1]);
        invert.a[0][2] = s * (this.a[0][1] * this.a[1][2] - this.a[0][2] * this.a[1][1]);
        invert.a[1][2] = s * (this.a[0][2] * this.a[1][0] - this.a[0][0] * this.a[1][2]);
        invert.a[2][2] = s * (this.a[0][0] * this.a[1][1] - this.a[0][1] * this.a[1][0]);
        return invert;
    }

    public AffineTransform toAffineTransform() throws NoSolutionException {
        if (!(Math.abs(this.a[2][0]) <= 0.01 && Math.abs(this.a[2][1]) <= 0.01 && Math.abs(this.a[2][2] - 1.0) <= 0.01)) {
            throw new NoSolutionException("Resulted matrix is not AF");
        }
        return new AffineTransform(this.a[0][0], this.a[1][0], this.a[0][1], this.a[1][1], this.a[0][2], this.a[1][2]);
    }
}

