/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.layer;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PicLayerFromFile
extends PicLayerAbstract {
    private File m_file;
    private boolean isZip;
    private String imgNameInZip;
    private String m_tooltiptext;

    public PicLayerFromFile(File file) {
        this.m_file = file;
        if ("zip".equalsIgnoreCase(PicLayerFromFile.getFileExtension(file))) {
            this.isZip = true;
        }
        this.m_tooltiptext = this.m_file.getAbsolutePath();
        this.setName(this.m_file.getName());
    }

    @Override
    protected Image createImage() throws IOException {
        BufferedImage image = null;
        if (this.isZip) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(this.m_file);
                ZipEntry imgEntry = null;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                String[] supportedImageExtensions = ImageIO.getReaderFormatNames();
                block17: while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String[] stringArray = supportedImageExtensions;
                    int n = supportedImageExtensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String extension = stringArray[n2];
                        if (entry.getName().endsWith("." + extension)) {
                            imgEntry = entry;
                            break block17;
                        }
                        ++n2;
                    }
                }
                if (imgEntry != null) {
                    this.imgNameInZip = imgEntry.getName();
                    InputStream is = null;
                    try {
                        is = zipFile.getInputStream(imgEntry);
                        BufferedImage bufferedImage = image = ImageIO.read(is);
                        return bufferedImage;
                    }
                    finally {
                        Utils.close((Closeable)is);
                    }
                }
                System.err.println("Warning: no image in zip file found");
            }
            catch (Exception e) {
                System.err.println(I18n.tr((String)"Warning: failed to handle zip file ''{0}''. Exception was: {1}", (Object[])new Object[]{this.m_file.getName(), e.toString()}));
                return null;
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }
        image = ImageIO.read(this.m_file);
        return image;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void lookForCalibration() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 20[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean confirmCalibrationLoading(String fileName) {
        String prefkey = "piclayer.autoloadcal";
        String policy = Main.pref.get(prefkey, "");
        policy = policy.trim().toLowerCase();
        boolean loadcal = false;
        String msg = I18n.tr((String)"A calibration file associated to the picture file was found: {0}\n", (Object[])new Object[]{fileName});
        if (policy.equals("yes")) {
            loadcal = true;
        } else if (policy.equals("no")) {
            loadcal = false;
        } else if (policy.equals("ask")) {
            msg = String.valueOf(msg) + "\n" + I18n.tr((String)"Set \"{0}\" to yes/no/ask in the preferences\nto control the autoloading of calibration files.", (Object[])new Object[]{prefkey});
            int answer = JOptionPane.showConfirmDialog(Main.parent, msg = String.valueOf(msg) + "\n" + I18n.tr((String)"Do you want to apply it ?", (Object[])new Object[0]), I18n.tr((String)"Load calibration file ?", (Object[])new Object[0]), 0);
            if (answer == 0) {
                loadcal = true;
            }
        } else {
            msg = String.valueOf(msg) + "\n" + I18n.tr((String)"It will be applied automatically.", (Object[])new Object[0]);
            msg = String.valueOf(msg) + "\n" + I18n.tr((String)"Also, from now on, calibration files will always be loaded automatically.", (Object[])new Object[0]);
            msg = String.valueOf(msg) + "\n" + I18n.tr((String)"Set \"{0}\" to yes/no/ask in the preferences\nto control the autoloading of calibration files.", (Object[])new Object[]{prefkey});
            JOptionPane.showMessageDialog(Main.parent, msg, "Automatic loading of the calibration", 1);
            Main.pref.put(prefkey, "yes");
            loadcal = true;
        }
        return loadcal;
    }

    @Override
    public String getPicLayerName() {
        return this.m_tooltiptext;
    }

    public static String getFileExtension(File f) {
        int dotIdx = f.getName().lastIndexOf(46);
        if (dotIdx == -1) {
            return "";
        }
        return f.getName().substring(dotIdx + 1);
    }

    public static class CalData {
        public String[] imgExt;
        public String[] calExt;
        public CalibrationType type;

        public CalData(String[] imgExt, String[] calExt, CalibrationType type) {
            this.imgExt = imgExt;
            this.calExt = calExt;
            this.type = type;
        }
    }

    public static enum CalibrationType {
        CAL,
        WORLDFILE;

    }
}

