/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.plugins.fastdraw.FDSettings;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.TextTagParser;
import org.openstreetmap.josm.tools.Utils;

public class FastDrawConfigDialog
extends ExtendedDialog {
    public FastDrawConfigDialog(FDSettings settings) {
        super(Main.parent, I18n.tr((String)"FastDraw configuration", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        JPanel all = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        all.setLayout(layout);
        JLabel label1 = new JLabel(I18n.tr((String)"Epsilon multiplier", (Object[])new Object[0]));
        JLabel label2 = new JLabel(I18n.tr((String)"Starting Epsilon", (Object[])new Object[0]));
        JLabel label3 = new JLabel(I18n.tr((String)"Max points count per 1 km", (Object[])new Object[0]));
        JLabel label4 = new JLabel(I18n.tr((String)"Enter key mode", (Object[])new Object[0]));
        JLabel label5 = new JLabel(I18n.tr((String)"Auto add tags", (Object[])new Object[0]));
        JFormattedTextField text1 = new JFormattedTextField(NumberFormat.getInstance());
        JFormattedTextField text2 = new JFormattedTextField(NumberFormat.getInstance());
        JFormattedTextField text3 = new JFormattedTextField(NumberFormat.getInstance());
        JComboBox<String> combo1 = new JComboBox<String>(new String[]{I18n.tr((String)"Autosimplify", (Object[])new Object[0]), I18n.tr((String)"Simplify with initial epsilon", (Object[])new Object[0]), I18n.tr((String)"Save as is", (Object[])new Object[0])});
        JCheckBox snapCb = new JCheckBox(I18n.tr((String)"Snap to nodes", (Object[])new Object[0]));
        JCheckBox fixedClickCb = new JCheckBox(I18n.tr((String)"Add fixed points on click", (Object[])new Object[0]));
        JCheckBox fixedSpaceCb = new JCheckBox(I18n.tr((String)"Add fixed points on spacebar", (Object[])new Object[0]));
        JCheckBox drawClosedCb = new JCheckBox(I18n.tr((String)"Draw closed polygons only", (Object[])new Object[0]));
        final HistoryComboBox addTags = new HistoryComboBox();
        JButton pasteButton = new JButton(new AbstractAction(I18n.tr((String)"Paste", (Object[])new Object[0]), ImageProvider.get((String)"apply")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = Utils.getClipboardContent();
                if (TextTagParser.getValidatedTagsFromText((String)s) != null) {
                    addTags.setText(s);
                }
            }
        });
        pasteButton.setToolTipText(I18n.tr((String)"Try copying tags from properties table", (Object[])new Object[0]));
        addTags.setPossibleItems(Main.pref.getCollection("fastdraw.tags-history"));
        all.add((Component)label1, GBC.std().insets(10, 0, 0, 0));
        all.add((Component)text1, GBC.eol().fill(2).insets(5, 0, 0, 5));
        all.add((Component)label2, GBC.std().insets(10, 0, 0, 0));
        all.add((Component)text2, GBC.eol().fill(2).insets(5, 0, 0, 5));
        all.add((Component)label3, GBC.std().insets(10, 0, 0, 0));
        all.add((Component)text3, GBC.eol().fill(2).insets(5, 0, 0, 5));
        all.add((Component)label4, GBC.std().insets(10, 0, 0, 0));
        all.add(combo1, GBC.eop().fill(2).insets(5, 0, 0, 5));
        all.add((Component)label5, GBC.std().insets(10, 0, 0, 0));
        all.add((Component)pasteButton, GBC.eop().insets(0, 0, 0, 5));
        all.add((Component)addTags, GBC.eop().fill(2).insets(10, 0, 5, 10));
        all.add((Component)snapCb, GBC.eop().insets(20, 0, 0, 0));
        all.add((Component)fixedClickCb, GBC.eop().insets(20, 0, 0, 0));
        all.add((Component)fixedSpaceCb, GBC.eop().insets(20, 0, 0, 0));
        all.add((Component)drawClosedCb, GBC.eop().insets(20, 0, 0, 0));
        addTags.setText(settings.autoTags);
        text1.setValue(settings.epsilonMult);
        text2.setValue(settings.startingEps);
        text3.setValue(settings.maxPointsPerKm);
        snapCb.setSelected(settings.snapNodes);
        fixedClickCb.setSelected(settings.fixedClick);
        fixedSpaceCb.setSelected(settings.fixedSpacebar);
        drawClosedCb.setSelected(settings.drawClosed);
        combo1.setSelectedIndex(settings.simplifyMode);
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr((String)"FastDraw settings", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        this.setContent(all, false);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setToolTipTexts(new String[]{I18n.tr((String)"Save settings", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
        this.setDefaultButton(1);
        this.showDialog();
        if (dialog.getValue() == 0) {
            try {
                settings.epsilonMult = NumberFormat.getInstance().parse(text1.getText()).doubleValue();
                settings.startingEps = NumberFormat.getInstance().parse(text2.getText()).doubleValue();
                settings.maxPointsPerKm = NumberFormat.getInstance().parse(text3.getText()).doubleValue();
                settings.snapNodes = snapCb.isSelected();
                settings.fixedClick = fixedClickCb.isSelected();
                settings.fixedSpacebar = fixedSpaceCb.isSelected();
                settings.drawClosed = drawClosedCb.isSelected();
                settings.simplifyMode = combo1.getSelectedIndex();
                settings.autoTags = addTags.getText();
                addTags.addCurrentItemToHistory();
                Main.pref.putCollection("fastdraw.tags-history", (Collection)addTags.getHistory());
                settings.savePrefs();
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Can not read settings", (Object[])new Object[0]));
            }
        }
    }
}

