/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.measurement;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.plugins.measurement.MeasurementLayer;
import org.openstreetmap.josm.plugins.measurement.MeasurementPlugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class MeasurementDialog
extends ToggleDialog
implements SelectionChangedListener {
    private static final long serialVersionUID = 4708541586297950021L;
    private SideButton resetButton = new SideButton((Action)new AbstractAction(){
        {
            this.putValue("Name", I18n.tr((String)"Reset", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"select"));
            this.putValue("ShortDescription", I18n.tr((String)"Reset current measurement results and delete measurement path.", (Object[])new Object[0]));
            this.putValue("help", HelpUtil.ht((String)"/Dialog/Measurement#Reset"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MeasurementDialog.this.resetValues();
        }
    });
    protected JLabel pathLengthLabel;
    protected JLabel selectLengthLabel;
    protected JLabel selectAreaLabel;
    protected JLabel segAngleLabel;

    public MeasurementDialog() {
        super(I18n.tr((String)"Measured values", (Object[])new Object[0]), "measure", I18n.tr((String)"Open the measurement window.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"subwindow:measurement", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Measured values", (Object[])new Object[0])}), (int)85, (int)5009), 150);
        JPanel valuePanel = new JPanel(new GridLayout(0, 2));
        valuePanel.add(new JLabel(I18n.tr((String)"Path Length", (Object[])new Object[0])));
        this.pathLengthLabel = new JLabel(NavigatableComponent.getDistText((double)0.0));
        valuePanel.add(this.pathLengthLabel);
        valuePanel.add(new JLabel(I18n.tr((String)"Selection Length", (Object[])new Object[0])));
        this.selectLengthLabel = new JLabel(NavigatableComponent.getDistText((double)0.0));
        valuePanel.add(this.selectLengthLabel);
        valuePanel.add(new JLabel(I18n.tr((String)"Selection Area", (Object[])new Object[0])));
        this.selectAreaLabel = new JLabel(NavigatableComponent.getAreaText((double)0.0));
        valuePanel.add(this.selectAreaLabel);
        JLabel angle = new JLabel(I18n.tr((String)"Angle", (Object[])new Object[0]));
        angle.setToolTipText(I18n.tr((String)"Angle between two selected Nodes", (Object[])new Object[0]));
        valuePanel.add(angle);
        this.segAngleLabel = new JLabel("- \u00b0");
        valuePanel.add(this.segAngleLabel);
        this.setPreferredSize(new Dimension(0, 92));
        this.createLayout(valuePanel, false, Arrays.asList(this.resetButton));
        DataSet.addSelectionListener((SelectionChangedListener)this);
    }

    public void resetValues() {
        MeasurementPlugin.getCurrentLayer().reset();
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        double length = 0.0;
        double segAngle = 0.0;
        double area = 0.0;
        Node lastNode = null;
        for (OsmPrimitive osmPrimitive : newSelection) {
            if (osmPrimitive instanceof Node && !((Node)osmPrimitive).isIncomplete()) {
                Node n = (Node)osmPrimitive;
                if (lastNode == null) {
                    lastNode = n;
                    continue;
                }
                length += lastNode.getCoor().greatCircleDistance(n.getCoor());
                segAngle = MeasurementLayer.angleBetween(lastNode.getCoor(), n.getCoor());
                lastNode = n;
                continue;
            }
            if (!(osmPrimitive instanceof Way)) continue;
            Way w = (Way)osmPrimitive;
            Node lastN = null;
            for (Node n : w.getNodes()) {
                if (lastN != null && lastN.getCoor() != null && n.getCoor() != null) {
                    length += lastN.getCoor().greatCircleDistance(n.getCoor());
                    area += MeasurementLayer.calcX(n.getCoor()) * MeasurementLayer.calcY(lastN.getCoor()) - MeasurementLayer.calcY(n.getCoor()) * MeasurementLayer.calcX(lastN.getCoor());
                    segAngle = MeasurementLayer.angleBetween(lastN.getCoor(), n.getCoor());
                }
                lastN = n;
            }
            area = lastN != null && lastN == w.getNodes().iterator().next() ? Math.abs(area / 2.0) : 0.0;
        }
        final String string = NavigatableComponent.getDistText((double)length);
        final String angleLabel = String.valueOf(new DecimalFormat("#0.0").format(segAngle)) + " \u00b0";
        final String areaLabel = NavigatableComponent.getAreaText((double)area);
        GuiHelper.runInEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                MeasurementDialog.this.selectLengthLabel.setText(string);
                MeasurementDialog.this.segAngleLabel.setText(angleLabel);
                MeasurementDialog.this.selectAreaLabel.setText(areaLabel);
            }
        });
    }

    public void destroy() {
        super.destroy();
        DataSet.removeSelectionListener((SelectionChangedListener)this);
    }
}

