/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.writing;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMEntity;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMNode;

public class OSMXMLWriter {
    String filename;
    ChannelDiGraph digraph;
    XMLStreamWriter writer;

    public OSMXMLWriter(String filename, ChannelDiGraph digraph) {
        this.filename = filename;
        this.digraph = digraph;
    }

    public void writeXML() throws FileNotFoundException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.writer = factory.createXMLStreamWriter(new FileOutputStream(this.filename));
        this.writer.writeStartDocument("utf-8", "1.0");
        this.writer.writeStartElement("osm");
        this.writer.writeAttribute("version", "0.6");
        this.writer.writeAttribute("generator", "channelGenerator");
        this.writer.writeEmptyElement("bounds");
        this.writer.writeAttribute("minlat", Double.toString(this.digraph.getBbbottom()));
        this.writer.writeAttribute("minlon", Double.toString(this.digraph.getBbleft()));
        this.writer.writeAttribute("maxlat", Double.toString(this.digraph.getBbtop()));
        this.writer.writeAttribute("maxlon", Double.toString(this.digraph.getBbright()));
        OSMNode[] nodes = this.digraph.getAllOSMNodes();
        int i = 0;
        while (i < nodes.length) {
            this.writer.writeEmptyElement("node");
            this.writeAttributes(nodes[i]);
            ++i;
        }
        ArrayList<Channel> ways = this.digraph.getChannels();
        int i2 = 0;
        while (i2 < ways.size()) {
            this.writer.writeStartElement("way");
            this.writer.writeAttribute("id", Integer.toString(ways.get(i2).getNewid()));
            this.writeAttributes(ways.get(i2).getWay());
            this.writer.writeEmptyElement("nd");
            this.writer.writeAttribute("ref", Long.toString(ways.get(i2).getFromNode().getId()));
            this.writer.writeEmptyElement("nd");
            this.writer.writeAttribute("ref", Long.toString(ways.get(i2).getToNode().getId()));
            HashMap<String, String> tags = ways.get(i2).getWay().getHashmap();
            Set<String> keys = tags.keySet();
            for (String t : keys) {
                this.writer.writeEmptyElement("tag");
                this.writer.writeAttribute("k", t);
                this.writer.writeAttribute("v", tags.get(t));
            }
            this.writer.writeEmptyElement("tag");
            this.writer.writeAttribute("k", "ID");
            this.writer.writeAttribute("v", Integer.toString(ways.get(i2).getNewid()));
            this.writer.writeEmptyElement("tag");
            this.writer.writeAttribute("k", "SCC");
            if (ways.get(i2).isStrongConnected()) {
                this.writer.writeAttribute("v", "true");
            } else {
                this.writer.writeAttribute("v", "false");
            }
            this.writer.writeEndElement();
            ++i2;
        }
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.close();
    }

    private void writeAttributes(OSMEntity ent) throws FileNotFoundException, XMLStreamException {
        if (ent instanceof OSMNode) {
            this.writer.writeAttribute("id", Long.toString(ent.getId()));
            this.writer.writeAttribute("lat", Double.toString(((OSMNode)ent).getLatitude()));
            this.writer.writeAttribute("lon", Double.toString(((OSMNode)ent).getLongitude()));
        }
        if (ent.getTimestamp() != null) {
            this.writer.writeAttribute("timestamp", ent.getTimestamp());
        }
        if (ent.isVisible()) {
            this.writer.writeAttribute("visible", "true");
        } else {
            this.writer.writeAttribute("visible", "false");
        }
        this.writer.writeAttribute("version", Integer.toString(ent.getVersion()));
    }
}

