/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.component.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URI;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapdust.gui.component.util.ComponentUtil;
import org.openstreetmap.josm.plugins.mapdust.util.Configuration;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class MapdustHelpPanel
extends JPanel
implements HyperlinkListener {
    private static final long serialVersionUID = 8366853437915060878L;

    public MapdustHelpPanel() {
        this.setLayout(new BorderLayout());
        String name = "Help";
        this.setName(name);
        String txt = this.buildText();
        JEditorPane txtHelp = new JEditorPane("text/html", "");
        txtHelp.setEditorKit(new HTMLEditorKit());
        txtHelp.setEditable(false);
        txtHelp.setText(txt);
        txtHelp.addHyperlinkListener(this);
        JScrollPane cmpDescription = ComponentUtil.createJScrollPane(txtHelp, null, Color.white, true, true);
        cmpDescription.setPreferredSize(new Dimension(100, 100));
        this.add((Component)cmpDescription, "Center");
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String url = Configuration.getInstance().getMapdustWiki();
            try {
                OpenBrowser.displayUrl((URI)new URI(url));
            }
            catch (Exception e) {
                String errorMessage = "Error opening the MapDust wiki page";
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)errorMessage, (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
        }
    }

    private String buildText() {
        Integer version = Integer.decode(Main.pref.get("mapdust.version"));
        Integer localVersion = Integer.decode(Main.pref.get("mapdust.localVersion"));
        String txt = "<html>";
        txt = txt + "<font style='font-size:10px' face='Times New Roman'>";
        txt = txt + "<b>You are using MapDust version ";
        txt = txt + "<i style='color:red;font-size:10px'>";
        if (version <= localVersion) {
            txt = txt + version + "</i>.</b><br>";
        } else {
            txt = txt + localVersion + "</i>. There is an update available. ";
            txt = txt + "Please update to version ";
            txt = txt + "<i style='color:red;font-size:10px'>" + version;
            txt = txt + "</i> to benefit from the latest improvements.</b><br>";
        }
        txt = txt + "<b>To add bugs on the map you need to activate ";
        txt = txt + "the MapDust layer in the Layer List Dialog.";
        txt = txt + "Click <a href='' target='_blank'>here</a> for more help.";
        txt = txt + "</b></font></html>";
        return txt;
    }
}

