/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.WMSLayer;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.tools.I18n;

public class MenuActionSaveRasterAs
extends JosmAction {
    public static String name = I18n.marktr((String)"Save image as PNG");
    private static final long serialVersionUID = 1L;
    private WMSLayer wmsLayer;
    FiltrePng filtrePng = new FiltrePng();

    public MenuActionSaveRasterAs(WMSLayer wmsLayer) {
        super(I18n.tr((String)name, (Object[])new Object[0]), "save", I18n.tr((String)"Export as PNG format (only raster images)", (Object[])new Object[0]), null, false);
        this.wmsLayer = wmsLayer;
    }

    public void actionPerformed(ActionEvent arg0) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(this.filtrePng);
        int returnVal = fc.showSaveDialog(Main.parent);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            if (!file.getName().endsWith(".png")) {
                file = new File(file.getParent(), file.getName() + ".png");
            }
            BufferedImage bi = this.wmsLayer.getImage((int)0).image;
            try {
                ImageIO.write((RenderedImage)bi, "png", file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class FiltrePng
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".png");
        }

        @Override
        public String getDescription() {
            return I18n.tr((String)"PNG files (*.png)", (Object[])new Object[0]);
        }
    }
}

