/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.converting;

import java.util.ArrayList;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.LeadsTo;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMRelation;

public class TurnRestrictionChecker {
    private final ArrayList<OSMRelation> turnrestrictionsrelations = new ArrayList();
    private final ChannelDiGraph channelDigraph;
    private final boolean isInturnrestriction;
    private int relationpointer;
    private LeadsTo tempLeadsTo;

    public TurnRestrictionChecker(OSMGraph graph, ChannelDiGraph channelDigraph) {
        int i = 0;
        while (i < graph.getRelations().length) {
            if (graph.getRelations()[i].hasKey("type") && graph.getRelations()[i].getValue("type").equals("restriction")) {
                this.turnrestrictionsrelations.add(graph.getRelations()[i]);
            }
            ++i;
        }
        this.channelDigraph = channelDigraph;
        this.isInturnrestriction = false;
    }

    private boolean checkForRelations(Channel channel) {
        int k = 0;
        while (k < this.turnrestrictionsrelations.size()) {
            int i = 0;
            while (i < channel.getWays().size()) {
                if (this.turnrestrictionsrelations.get(k).getMember("from").getId() == channel.getWays().get(i).getId() && this.turnrestrictionsrelations.get(k).getMember("via").getId() == channel.getToNode().getId()) {
                    this.relationpointer = k;
                    return true;
                }
                ++i;
            }
            ++k;
        }
        return false;
    }

    private void produceLeadsToFromRelation(Channel fromChannel, Channel toChannel) {
        if (toChannel.getWays().contains(this.turnrestrictionsrelations.get(this.relationpointer).getMember("to"))) {
            if (this.turnrestrictionsrelations.get(this.relationpointer).getValue("restriction").startsWith("only")) {
                this.tempLeadsTo = new LeadsTo(fromChannel, toChannel);
                this.channelDigraph.addLeadsTo(this.tempLeadsTo);
                toChannel.addPredChannel(fromChannel);
            } else if (this.turnrestrictionsrelations.get(this.relationpointer).getValue("restriction").startsWith("no")) {
                int i = 0;
                while (i < fromChannel.getToNode().getOutgoingChannels().size()) {
                    if (fromChannel.getToNode().getOutgoingChannels().get(i) != toChannel) {
                        this.tempLeadsTo = new LeadsTo(fromChannel, fromChannel.getToNode().getOutgoingChannels().get(i));
                        this.channelDigraph.addLeadsTo(this.tempLeadsTo);
                        fromChannel.getToNode().getOutgoingChannels().get(i).addPredChannel(fromChannel);
                    }
                    ++i;
                }
            }
        }
    }

    public void createLeadsTo() {
        int i = 0;
        while (i < this.channelDigraph.getChannels().size()) {
            Channel tempChannel = this.channelDigraph.getChannelAtPosition(i);
            boolean isInRelation = this.checkForRelations(tempChannel);
            int j = 0;
            while (j < tempChannel.getToNode().getOutgoingChannels().size()) {
                if (isInRelation) {
                    this.produceLeadsToFromRelation(tempChannel, tempChannel.getToNode().getOutgoingChannels().get(j));
                } else if (tempChannel.getBackChannelID() != tempChannel.getToNode().getOutgoingChannels().get(j).getNewid() || tempChannel.getToNode().getOutgoingChannels().size() == 1) {
                    this.tempLeadsTo = new LeadsTo(tempChannel, tempChannel.getToNode().getOutgoingChannels().get(j));
                    this.channelDigraph.addLeadsTo(this.tempLeadsTo);
                    tempChannel.getToNode().getOutgoingChannels().get(j).addPredChannel(tempChannel);
                }
                ++j;
            }
            ++i;
        }
    }
}

