/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking;

import java.util.ArrayList;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.LeadsTo;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.BackPropagation;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.TRDFS;

public class JProcess {
    private ArrayList<Channel> vertices;
    private ChannelDiGraph digraph;
    private TRDFS trdfs;
    private BackPropagation backpropagation;
    private ArrayList<LeadsTo> cycleEdges;

    public JProcess(ArrayList<Channel> subgraph, ChannelDiGraph digraph) {
        this.digraph = digraph;
        this.vertices = subgraph;
        this.trdfs = new TRDFS(this.vertices, digraph);
        this.backpropagation = new BackPropagation(digraph);
    }

    public void jProcess(ArrayList<Channel> entries) {
        ArrayList<Channel> nodes = this.digraph.getChannels();
        int i = 0;
        while (i < nodes.size()) {
            nodes.get(i).setVisited(-1);
            nodes.get(i).ereaseReachableNodes();
            ++i;
        }
        i = 0;
        while (i < this.digraph.getLeadsTo().size()) {
            this.digraph.getLeadsTo().get(i).setForwardEdge(false);
            ++i;
        }
        this.trdfs.ereaseCycleEdges();
        i = 0;
        while (i < entries.size()) {
            if (entries.get(i).getVisited() == -1) {
                this.trdfs.trdfs(entries.get(i));
            }
            ++i;
        }
        this.cycleEdges = this.trdfs.getCycleEdges();
        int j = 0;
        while (j < this.cycleEdges.size()) {
            this.backpropagation.backPropagation(this.cycleEdges.get(j).getFromChannel(), this.cycleEdges.get(j).getToChannel(), this.cycleEdges.get(j).getToChannel());
            ++j;
        }
    }
}

