/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.datastructure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Graph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.LeadsTo;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMNode;

public class ChannelDiGraph
extends Graph {
    private ArrayList<Channel> channels = new ArrayList();
    private final ArrayList<LeadsTo> leadsTos = new ArrayList();
    private final HashSet<Channel> selectedChannels = new HashSet();
    private HashSet<Channel> junctioncandidate = new HashSet();

    public void setChannels(ArrayList<Channel> channels) {
        this.channels = channels;
    }

    public Channel getChannelWithFromNode(OSMNode node) {
        int i = 0;
        while (i < this.channels.size()) {
            if (this.channels.get(i).getFromNode() == node) {
                return this.channels.get(i);
            }
            ++i;
        }
        return null;
    }

    public ArrayList<Channel> getChannels() {
        return this.channels;
    }

    public void removeChannel(Channel channel) {
        this.channels.remove(channel);
    }

    public void addChannel(Channel channel) {
        this.channels.add(channel);
    }

    public int numberOfChannels() {
        return this.channels.size();
    }

    public Channel getChannelAtPosition(int i) {
        return this.channels.get(i);
    }

    public Channel getChannelWithID(int id) {
        int i = 0;
        while (i < this.channels.size()) {
            if (this.channels.get(i).getNewid() == id) {
                return this.channels.get(i);
            }
            ++i;
        }
        return null;
    }

    public OSMNode[] getAllOSMNodes() {
        HashMap<Long, OSMNode> nodes = new HashMap<Long, OSMNode>();
        int i = 0;
        while (i < this.channels.size()) {
            if (!nodes.containsKey(this.channels.get(i).getFromNode().getId())) {
                nodes.put(this.channels.get(i).getFromNode().getId(), this.channels.get(i).getFromNode());
            }
            if (!nodes.containsKey(this.channels.get(i).getToNode().getId())) {
                nodes.put(this.channels.get(i).getToNode().getId(), this.channels.get(i).getToNode());
            }
            ++i;
        }
        OSMNode[] nodearray = new OSMNode[nodes.size()];
        return nodes.values().toArray(nodearray);
    }

    public ArrayList<LeadsTo> getLeadsTo() {
        return this.leadsTos;
    }

    public void setForwardEdge(Channel fromChannel, Channel toChannel) {
        int i = 0;
        while (i < this.leadsTos.size()) {
            if (this.leadsTos.get(i).getFromChannel() == fromChannel && this.leadsTos.get(i).getToChannel() == toChannel) {
                this.leadsTos.get(i).setForwardEdge(true);
            }
            ++i;
        }
    }

    public void addLeadsTo(LeadsTo leadsTo) {
        this.leadsTos.add(leadsTo);
        int i = 0;
        while (i < this.channels.size()) {
            if (this.channels.get(i).getNewid() == leadsTo.getFromChannel().getNewid()) {
                this.channels.get(i).addLeadsTo(leadsTo);
                return;
            }
            ++i;
        }
    }

    public void removeLeadsTo(LeadsTo leadsTo) {
        this.leadsTos.remove(leadsTo);
        int i = 0;
        while (i < this.channels.size()) {
            if (this.channels.get(i).equals(leadsTo.getFromChannel())) {
                this.channels.get(i).removeLeadsTo(leadsTo);
                return;
            }
            ++i;
        }
    }

    public LeadsTo getLeadsTo(Channel fromChannel, Channel toChannel) {
        int i = 0;
        while (i < this.leadsTos.size()) {
            if (this.leadsTos.get(i).getFromChannel().getNewid() == fromChannel.getNewid() && this.leadsTos.get(i).getToChannel().getNewid() == toChannel.getNewid()) {
                return this.leadsTos.get(i);
            }
            ++i;
        }
        return null;
    }

    public ArrayList<Channel> getChannelsTouchingOSMNodes(ArrayList<OSMNode> nodes) {
        ArrayList<Channel> touchingChannel = new ArrayList<Channel>();
        int i = 0;
        while (i < nodes.size()) {
            int j = 0;
            while (j < this.channels.size()) {
                if (this.channels.get(j).getFromNode().getId() == nodes.get(i).getId()) {
                    if (!touchingChannel.contains(this.channels.get(j))) {
                        touchingChannel.add(this.channels.get(j));
                    }
                } else if (this.channels.get(j).getToNode().getId() == nodes.get(i).getId() && !touchingChannel.contains(this.channels.get(j))) {
                    touchingChannel.add(this.channels.get(j));
                }
                ++j;
            }
            ++i;
        }
        return touchingChannel;
    }

    public ArrayList<Channel> getChannelsTouchingOSMNode(long id) {
        ArrayList<Channel> returnchannels = new ArrayList<Channel>();
        int i = 0;
        while (i < this.channels.size()) {
            if (this.channels.get(i).getFromNode().getId() == id) {
                returnchannels.add(this.channels.get(i));
            }
            if (this.channels.get(i).getToNode().getId() == id) {
                returnchannels.add(this.channels.get(i));
            }
            ++i;
        }
        return returnchannels;
    }

    public ArrayList<Channel> getChannelsBetween(int idfrom, int idto) {
        ArrayList<Channel> channelsresult = new ArrayList<Channel>();
        int i = 0;
        while (i < this.channels.size()) {
            if (this.channels.get(i).getFromNode().getId() == (long)idfrom) {
                if (this.channels.get(i).getToNode().getId() == (long)idto) {
                    channelsresult.add(this.channels.get(i));
                }
            } else if (this.channels.get(i).getFromNode().getId() == (long)idto && this.channels.get(i).getToNode().getId() == (long)idfrom) {
                channelsresult.add(this.channels.get(i));
            }
            ++i;
        }
        return channelsresult;
    }

    public ArrayList<Channel> getChannelswithWayID(int id) {
        ArrayList<Channel> channelsresult = new ArrayList<Channel>();
        int i = 0;
        while (i < this.channels.size()) {
            if (this.channels.get(i).getWay().getId() == (long)id) {
                channelsresult.add(this.channels.get(i));
            }
            ++i;
        }
        return channelsresult;
    }

    public void detectSelectedChannels(double left, double top, double right, double bottom) {
        int i = 0;
        while (i < this.channels.size()) {
            if (this.channels.get(i).getFromNode().getLatitude() <= top && this.channels.get(i).getFromNode().getLatitude() >= bottom && this.channels.get(i).getFromNode().getLongitude() >= left && this.channels.get(i).getFromNode().getLongitude() <= right) {
                this.channels.get(i).setSelected(true);
                this.selectedChannels.add(this.channels.get(i));
            }
            if (this.channels.get(i).getToNode().getLatitude() <= top && this.channels.get(i).getToNode().getLatitude() >= bottom && this.channels.get(i).getToNode().getLongitude() >= left && this.channels.get(i).getToNode().getLongitude() <= right) {
                this.channels.get(i).setSelected(true);
                this.selectedChannels.add(this.channels.get(i));
            }
            ++i;
        }
    }

    public void ereaseSelectedChannels() {
        int i = 0;
        while (i < this.selectedChannels.size()) {
            Iterator<Channel> it = this.selectedChannels.iterator();
            while (it.hasNext()) {
                it.next().setSelected(false);
            }
            ++i;
        }
        this.selectedChannels.clear();
    }

    public HashSet<Channel> getSelectedChannels() {
        return this.selectedChannels;
    }

    public HashSet<Channel> getJunctionCandidate() {
        return this.junctioncandidate;
    }

    public void ereaseJunctioncandidate() {
        Iterator<Channel> it = this.junctioncandidate.iterator();
        while (it.hasNext()) {
            it.next().setPartOfJunction(false);
        }
        this.junctioncandidate.clear();
    }

    public void setJunctioncandidate(HashSet<Channel> junctionCandidate) {
        this.junctioncandidate.clear();
        this.junctioncandidate = junctionCandidate;
        Iterator<Channel> it = junctionCandidate.iterator();
        while (it.hasNext()) {
            it.next().setPartOfJunction(true);
        }
    }

    public void addJunctioncandidateChannel(Channel channel) {
        this.junctioncandidate.add(channel);
        channel.setPartOfJunction(true);
    }
}

