/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.converting;

import org.openstreetmap.josm.plugins.JunctionChecker.converting.NodesConnectionProducer;
import org.openstreetmap.josm.plugins.JunctionChecker.converting.PseudoChannelRemover;
import org.openstreetmap.josm.plugins.JunctionChecker.converting.TurnRestrictionChecker;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMNode;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMWay;

public class ChannelDigraphBuilder {
    private final ChannelDiGraph digraph;
    private final OSMGraph osmgraph;
    private final OSMWay[] osmways;
    private Channel newChannel = new Channel();
    private final NodesConnectionProducer ncp;
    private int newid = 1;
    private TurnRestrictionChecker trchecker;
    Channel backChannel;

    public ChannelDigraphBuilder(OSMGraph osmgraph) {
        this.ncp = new NodesConnectionProducer(osmgraph);
        this.ncp.produceNodesConnections();
        this.digraph = new ChannelDiGraph();
        this.osmways = osmgraph.getWays();
        this.digraph.setBbbottom(osmgraph.getBbbottom());
        this.digraph.setBbleft(osmgraph.getBbleft());
        this.digraph.setBbright(osmgraph.getBbright());
        this.digraph.setBbtop(osmgraph.getBbtop());
        this.osmgraph = osmgraph;
    }

    private void setNewWayID(Channel channel) {
        channel.setNewid(this.newid);
        ++this.newid;
    }

    private Channel createChannel(OSMNode fromNode, OSMNode toNode, OSMWay way) {
        this.newChannel = new Channel();
        this.newChannel.setFromNode(fromNode);
        this.newChannel.setToNode(toNode);
        this.setNewWayID(this.newChannel);
        this.digraph.addChannel(this.newChannel);
        fromNode.addOutgoingChannel(this.newChannel);
        this.newChannel.addWay(way);
        return this.newChannel;
    }

    private void createBackChannel(OSMNode fromNode, OSMNode toNode, OSMWay way, Channel channel) {
        this.backChannel = new Channel();
        this.backChannel = this.createChannel(fromNode, toNode, way);
        this.backChannel.setBackChannelID(channel.getNewid());
        channel.setBackChannelID(this.backChannel.getNewid());
    }

    private void buildChannels(OSMWay way, boolean oneway) {
        Channel tempChannel = new Channel();
        OSMNode lastUsedNode = way.getFromNode();
        OSMNode[] nodes = way.getNodes();
        int i = 1;
        while (i < nodes.length) {
            if (nodes[i].getPredNodeList().size() > 1 || nodes[i].getSuccNodeList().size() > 1) {
                tempChannel = this.createChannel(lastUsedNode, nodes[i], way);
                if (!oneway) {
                    this.createBackChannel(nodes[i], lastUsedNode, way, tempChannel);
                }
                lastUsedNode = nodes[i];
            } else if (nodes[i].getSuccNodeList().size() == 0) {
                tempChannel = this.createChannel(lastUsedNode, nodes[i], way);
                if (!oneway) {
                    this.createBackChannel(nodes[i], lastUsedNode, way, tempChannel);
                }
            } else if (i == nodes.length - 1 && nodes[i].getSuccNodeList().size() == 1) {
                tempChannel = this.createChannel(lastUsedNode, nodes[i], way);
                if (!oneway) {
                    this.createBackChannel(nodes[i], lastUsedNode, way, tempChannel);
                }
                lastUsedNode = nodes[i];
            }
            ++i;
        }
    }

    public void buildChannelDigraph() {
        int i = 0;
        while (i < this.osmways.length) {
            this.buildChannels(this.osmways[i], this.osmways[i].isOneWay());
            ++i;
        }
        this.trchecker = new TurnRestrictionChecker(this.osmgraph, this.digraph);
        this.trchecker.createLeadsTo();
        PseudoChannelRemover pcr = new PseudoChannelRemover(this.digraph);
        pcr.removePseudoChannels();
    }

    public ChannelDiGraph getDigraph() {
        return this.digraph;
    }

    public void setNewid(int newid) {
        this.newid = newid;
    }

    public int getNewid() {
        return this.newid;
    }
}

