/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.connectedness;

import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;

public class StrongConnectednessCalculator {
    private int index = 0;
    private final ArrayList<Channel> stack = new ArrayList();
    private final ArrayList<ArrayList<Channel>> SCC = new ArrayList();
    private final int numberOfNodes;
    private int calculatedNodes = 0;
    private ArrayList<Channel> nsccchannels = new ArrayList();
    private final ChannelDiGraph digraph;
    int biggestPart = 0;

    public StrongConnectednessCalculator(ChannelDiGraph digraph) {
        this.digraph = digraph;
        this.numberOfNodes = digraph.numberOfChannels();
    }

    private int findUncalculatedNodes() {
        int i = 0;
        while (i < this.numberOfNodes) {
            if (this.digraph.getChannelAtPosition(i).getLowlink() == -1) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void calculateSCC() {
        while (this.calculatedNodes != this.numberOfNodes) {
            this.tarjan(this.digraph.getChannelAtPosition(this.findUncalculatedNodes()));
        }
        int i = 0;
        while (i < this.SCC.size()) {
            ++i;
        }
        this.findBiggestPiece();
        this.saveNotSCCChannel();
    }

    private void saveNotSCCChannel() {
        this.nsccchannels = new ArrayList();
        int i = 0;
        while (i < this.SCC.size()) {
            if (i != this.biggestPart) {
                this.nsccchannels.addAll((Collection<Channel>)this.SCC.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.nsccchannels.size()) {
            this.nsccchannels.get(i).setStrongConnected(false);
            ++i;
        }
    }

    private void findBiggestPiece() {
        int number = 0;
        int i = 0;
        while (i < this.SCC.size()) {
            if (this.SCC.get(i).size() > number) {
                this.biggestPart = i;
                number = this.SCC.get(i).size();
            }
            ++i;
        }
    }

    public String showNotstronglyConnectednessParts() {
        String s = new String();
        int i = 0;
        while (i < this.SCC.size()) {
            if (i != this.biggestPart) {
                s = String.valueOf(s) + "GraphKomponente: " + i + "\n";
                int j = 0;
                while (j < this.SCC.get(i).size()) {
                    s = String.valueOf(s) + "Channel: " + this.SCC.get(i).get(j).getNewid();
                    ++j;
                }
                s = String.valueOf(s) + "\n";
            }
            ++i;
        }
        return s;
    }

    public ArrayList<Channel> getNotConnectedChannels() {
        return this.nsccchannels;
    }

    private void tarjan(Channel v) {
        v.setIndex(this.index);
        v.setLowlink(this.index);
        ++this.index;
        this.stack.add(0, v);
        int i = 0;
        while (i < v.getLeadsTo().size()) {
            Channel n = v.getLeadsTo().get(i).getToChannel();
            if (n.getIndex() == -1) {
                this.tarjan(n);
                v.setLowlink(Math.min(v.getLowlink(), n.getLowlink()));
            } else if (this.stack.contains(n)) {
                v.setLowlink(Math.min(v.getLowlink(), n.getLowlink()));
            }
            ++i;
        }
        if (v.getLowlink() == v.getIndex()) {
            Channel n;
            ArrayList<Channel> component = new ArrayList<Channel>();
            do {
                n = this.stack.remove(0);
                component.add(n);
            } while (n != v);
            this.SCC.add(component);
            this.calculatedNodes += component.size();
        }
    }
}

