/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.connectedness;

import java.util.ArrayList;
import java.util.Vector;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.LeadsTo;

public class DiGraphSealer {
    private int newID = 1000000;
    private ChannelDiGraph digraph;

    public DiGraphSealer(ChannelDiGraph digraph) {
        this.digraph = digraph;
    }

    public DiGraphSealer(ChannelDiGraph digraph, int newID) {
        this.digraph = digraph;
        this.newID = newID;
    }

    public void sealingGraph() {
        LeadsTo tempLeadsTo;
        Channel tempChannel;
        Vector<Integer> outgoingChannelIDs = new Vector<Integer>();
        Vector<Integer> incomingChannelIDs = new Vector<Integer>();
        int i = 0;
        while (i < this.digraph.numberOfChannels()) {
            if (!this.digraph.isInBBox(this.digraph.getChannelAtPosition(i).getFromNode())) {
                incomingChannelIDs.add(i);
            }
            if (!this.digraph.isInBBox(this.digraph.getChannelAtPosition(i).getToNode())) {
                outgoingChannelIDs.add(i);
            }
            ++i;
        }
        int counter = 0;
        int i2 = 0;
        while (i2 < outgoingChannelIDs.size()) {
            if (this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(i2)).getLeadsTo().size() == 0) {
                tempChannel = new Channel(this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(i2)).getToNode(), this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(0)).getFromNode());
                tempLeadsTo = new LeadsTo(this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(i2)), tempChannel);
                this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(i2)).addLeadsTo(tempLeadsTo);
                this.digraph.addLeadsTo(tempLeadsTo);
                tempLeadsTo = new LeadsTo(tempChannel, this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(0)));
                tempChannel.addLeadsTo(tempLeadsTo);
                this.digraph.addLeadsTo(tempLeadsTo);
                tempChannel.addWay(this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(i2)).getWay());
                tempChannel.setNewid(this.newID);
                ++this.newID;
                this.digraph.addChannel(tempChannel);
                ++counter;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < incomingChannelIDs.size()) {
            if (this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(i2)).getPredChannels().size() == 0) {
                tempChannel = new Channel(this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(0)).getToNode(), this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(i2)).getFromNode());
                this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(i2)).addPredChannel(tempChannel);
                tempLeadsTo = new LeadsTo(tempChannel, this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(i2)));
                tempChannel.addLeadsTo(tempLeadsTo);
                this.digraph.addLeadsTo(tempLeadsTo);
                tempLeadsTo = new LeadsTo(this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(0)), tempChannel);
                this.digraph.getChannelAtPosition((Integer)outgoingChannelIDs.get(0)).addLeadsTo(tempLeadsTo);
                this.digraph.addLeadsTo(tempLeadsTo);
                tempChannel.addWay(this.digraph.getChannelAtPosition((Integer)incomingChannelIDs.get(i2)).getWay());
                tempChannel.setNewid(this.newID);
                ++this.newID;
                this.digraph.addChannel(tempChannel);
                ++counter;
            }
            ++i2;
        }
        this.deleteDuplicateChannels();
    }

    private void deleteDuplicateChannels() {
        ArrayList pointer = new ArrayList();
        int i = 0;
        while (i < this.digraph.getChannels().size()) {
            int j = i + 1;
            while (j < this.digraph.getChannels().size()) {
                if (this.digraph.getChannelAtPosition(i).getFromNode() == this.digraph.getChannelAtPosition(j).getFromNode() && this.digraph.getChannelAtPosition(i).getToNode() == this.digraph.getChannelAtPosition(j).getToNode()) {
                    this.digraph.removeChannel(this.digraph.getChannelAtPosition(j));
                }
                ++j;
            }
            ++i;
        }
    }

    public void setNewID(int newID) {
        this.newID = newID;
    }

    public int getNewID() {
        return this.newID;
    }

    public ChannelDiGraph getDiGraph() {
        return this.digraph;
    }
}

