/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui.action.show;

import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.action.show.MapdustShowAction;
import org.openstreetmap.josm.plugins.mapdust.gui.component.dialog.ChangeBugStatusDialog;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustButtonPanel;

public class ShowCloseBugAction
extends MapdustShowAction {
    private static final long serialVersionUID = 6459224244170352152L;

    public ShowCloseBugAction() {
    }

    public ShowCloseBugAction(MapdustPlugin mapdustPlugin) {
        this.setMapdustPlugin(mapdustPlugin);
        this.setTitle("Mark bug report as fixed");
        this.setIconName("dialogs/fixed.png");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event != null) {
            JToggleButton btn = null;
            if (event.getSource() instanceof JToggleButton) {
                btn = (JToggleButton)event.getSource();
            } else if (event.getSource() instanceof JMenuItem) {
                this.getButtonPanel().getBtnFixBugReport().setSelected(true);
            }
            this.disableButtons(this.getButtonPanel());
            ChangeBugStatusDialog dialog = new ChangeBugStatusDialog(this.getTitle(), this.getIconName(), "close", btn, this.getMapdustPlugin());
            dialog.setLocationRelativeTo(null);
            dialog.getContentPane().setPreferredSize(dialog.getSize());
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    @Override
    void disableButtons(MapdustButtonPanel buttonPanel) {
        buttonPanel.getBtnWorkOffline().setEnabled(false);
        buttonPanel.getBtnWorkOffline().setSelected(false);
        buttonPanel.getBtnWorkOffline().setFocusable(false);
        buttonPanel.getBtnRefresh().setEnabled(false);
        buttonPanel.getBtnRefresh().setSelected(false);
        buttonPanel.getBtnRefresh().setFocusable(false);
        buttonPanel.getBtnFilter().setEnabled(false);
        buttonPanel.getBtnFilter().setSelected(false);
        buttonPanel.getBtnFilter().setFocusable(false);
        buttonPanel.getBtnAddComment().setEnabled(false);
        buttonPanel.getBtnAddComment().setSelected(false);
        buttonPanel.getBtnAddComment().setFocusable(false);
        buttonPanel.getBtnInvalidateBugReport().setEnabled(false);
        buttonPanel.getBtnInvalidateBugReport().setSelected(false);
        buttonPanel.getBtnInvalidateBugReport().setFocusable(false);
        buttonPanel.getBtnReOpenBugReport().setEnabled(false);
        buttonPanel.getBtnReOpenBugReport().setSelected(false);
        buttonPanel.getBtnReOpenBugReport().setFocusable(false);
    }
}

