/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.access;

import java.util.Collection;
import java.util.HashMap;
import org.openstreetmap.josm.plugins.graphview.core.data.MapBasedTagGroup;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;
import org.openstreetmap.josm.plugins.graphview.core.util.TagCondition;

public final class Implication {
    private final TagCondition condition;
    private final Collection<Tag> impliedTags;

    public Implication(TagCondition condition, Collection<Tag> impliedTags) {
        this.condition = condition;
        this.impliedTags = impliedTags;
    }

    public TagGroup apply(TagGroup tags) {
        if (this.condition.matches(tags)) {
            HashMap<String, String> newTagMap = new HashMap<String, String>();
            for (Tag tag : tags) {
                newTagMap.put(tag.key, tag.value);
            }
            for (Tag impliedTag : this.impliedTags) {
                if (newTagMap.containsKey(impliedTag.key)) continue;
                newTagMap.put(impliedTag.key, impliedTag.value);
            }
            return new MapBasedTagGroup(newTagMap);
        }
        return tags;
    }

    public String toString() {
        return String.valueOf(this.condition.toString()) + " => " + this.impliedTags.toString();
    }
}

