/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.JCheck;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.JMinimality;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.JPrepare;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.JProcess;

public class JunctionChecker {
    private ArrayList<Channel> subgraph;
    private ArrayList<Channel> entries;
    private ArrayList<Channel> exits;
    private ArrayList<Channel> cycleedges;
    private ArrayList<Channel> subjunction;
    private int n;
    private final JPrepare jPrepare;
    private JProcess jProcess;
    private final ChannelDiGraph channeldigraph;
    private final JCheck jCheck;
    private ArrayList<Channel> E;
    private int[][] Grid;
    private boolean Check;
    private boolean smallerJunction;
    private JMinimality m;
    private ArrayList<HashSet<Channel>> junctions = new ArrayList();
    private long startIterate = 0L;
    private long stopIterate = 0L;
    private long startGenerate = 0L;

    public JunctionChecker(ChannelDiGraph channeldigraph, int n) {
        this.jPrepare = new JPrepare(channeldigraph);
        this.channeldigraph = channeldigraph;
        this.n = n;
        this.jCheck = new JCheck();
        this.subjunction = new ArrayList();
        this.smallerJunction = false;
    }

    public void checkjunctions(ArrayList<Channel> subgraph, ProgressMonitor pm) {
        this.jPrepare.jPrepare(subgraph);
        this.entries = this.jPrepare.getEntries();
        this.exits = this.jPrepare.getExits();
        this.jProcess = new JProcess(subgraph, this.channeldigraph);
        this.jProcess.jProcess(this.jPrepare.getEntries());
        boolean result = this.jCheck.jCheck(this.entries, this.exits, this.n);
        if (result) {
            this.collectECandidates(subgraph);
            this.ConstructGrid();
            this.m = new JMinimality(this.Grid, this.n, this.E, this.entries, this.exits, this.channeldigraph, pm, true);
            this.m.GenerateSubcolumns();
            this.Check = this.m.IterateThroughKn();
            if (!this.Check) {
                this.smallerJunction = true;
            }
            this.subjunction = this.m.getSubJunctionCandidate();
        } else {
            this.Check = false;
        }
    }

    public void junctionSearch(ArrayList<Channel> subgraph, ProgressMonitor pm) {
        this.jPrepare.jPrepare(subgraph);
        this.entries = this.jPrepare.getEntries();
        this.exits = this.jPrepare.getExits();
        this.jProcess = new JProcess(subgraph, this.channeldigraph);
        this.jProcess.jProcess(this.jPrepare.getEntries());
        this.collectECandidates(subgraph);
        this.ConstructGrid();
        this.jPrepare.resetSubgraph();
        this.m = new JMinimality(this.Grid, this.n, this.E, new ArrayList<Channel>(), new ArrayList<Channel>(), this.channeldigraph, pm, false);
        this.m.GenerateSubcolumns();
        this.Check = this.m.IterateThroughKn();
        this.junctions = this.checkJunctionCandidates(this.m.getJunctionCandidates());
    }

    public void junctionSearch(ArrayList<Channel> subgraph) {
        this.jPrepare.jPrepare(subgraph);
        this.entries = this.jPrepare.getEntries();
        this.exits = this.jPrepare.getExits();
        this.jProcess = new JProcess(subgraph, this.channeldigraph);
        this.jProcess.jProcess(this.jPrepare.getEntries());
        this.collectECandidates(subgraph);
        this.ConstructGrid();
        this.jPrepare.resetSubgraph();
        this.m = new JMinimality(this.Grid, this.n, this.E, new ArrayList<Channel>(), new ArrayList<Channel>(), this.channeldigraph, false);
        this.startGenerate = System.currentTimeMillis();
        this.m.GenerateSubcolumns();
        this.startIterate = System.currentTimeMillis();
        this.Check = this.m.IterateThroughKn();
        this.stopIterate = System.currentTimeMillis();
        this.junctions = this.checkJunctionCandidates(this.m.getJunctionCandidates());
    }

    private ArrayList<HashSet<Channel>> checkJunctionCandidates(ArrayList<HashSet<Channel>> junctioncandidates) {
        ArrayList junctions = (ArrayList)junctioncandidates.clone();
        int i = 0;
        while (i < junctioncandidates.size()) {
            int j = 0;
            while (j < junctioncandidates.size()) {
                if (junctioncandidates.get(i).containsAll((Collection)junctioncandidates.get(j))) {
                    junctions.removeAll((Collection)junctioncandidates.get(i));
                }
                ++j;
            }
            ++i;
        }
        return junctions;
    }

    private void collectECandidates(ArrayList<Channel> subgraph) {
        this.E = new ArrayList();
        int i = 0;
        while (i < subgraph.size()) {
            if (subgraph.get(i).getIndegree() + subgraph.get(i).getOutdegree() >= 3 || this.entries.contains(subgraph.get(i)) || this.exits.contains(subgraph.get(i))) {
                this.E.add(subgraph.get(i));
            }
            ++i;
        }
    }

    private void ConstructGrid() {
        this.Grid = new int[this.E.size()][this.E.size()];
        int y = 0;
        while (y < this.E.size()) {
            int x = 0;
            while (x < this.E.size()) {
                this.Grid[y][x] = x != y && !this.entries.contains(this.E.get(x)) && !this.exits.contains(this.E.get(y)) && this.E.get(y).getReachableNodes().contains(this.E.get(x)) ? 1 : 0;
                ++x;
            }
            ++y;
        }
    }

    public long getMeasuredIterateTime() {
        return this.stopIterate - this.startIterate;
    }

    public long getMeasuredGenerateTime() {
        return this.startIterate - this.startGenerate;
    }

    public ArrayList<Channel> getSubgraph() {
        return this.subgraph;
    }

    public void setSubgraph(ArrayList<Channel> subgraph) {
        this.subgraph = subgraph;
    }

    public ArrayList<Channel> getEntries() {
        return this.entries;
    }

    public void setEntries(ArrayList<Channel> entries) {
        this.entries = entries;
    }

    public ArrayList<Channel> getExits() {
        return this.exits;
    }

    public void setExits(ArrayList<Channel> exits) {
        this.exits = exits;
    }

    public ArrayList<Channel> getCycleedges() {
        return this.cycleedges;
    }

    public void setCycleedges(ArrayList<Channel> cycleedges) {
        this.cycleedges = cycleedges;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public ArrayList<Channel> getSubJunction() {
        return this.subjunction;
    }

    public boolean getCheck() {
        return this.Check;
    }

    public boolean isSmallerJunction() {
        return this.smallerJunction;
    }

    public String getJCheckResult() {
        return this.jCheck.getResult();
    }

    public ArrayList<HashSet<Channel>> getJunctions() {
        return this.junctions;
    }
}

