/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking;

public class Combination {
    private long n = 0L;
    private long k = 0L;
    long[] data = null;

    public Combination(long n, long k) {
        if (n < 0L || k < 0L) {
            try {
                throw new Exception("Negative parameter in constructor");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.n = n;
        this.k = k;
        this.data = new long[(int)k];
        long i = 0L;
        while (i < k) {
            this.data[(int)i] = i;
            ++i;
        }
    }

    public static long Choose(long n, long k) {
        long iMax;
        long delta;
        if (n < 0L || k < 0L) {
            try {
                throw new Exception("Invalid negative parameter in Choose()");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (n < k) {
            return 0L;
        }
        if (n == k) {
            return 1L;
        }
        if (k < n - k) {
            delta = n - k;
            iMax = k;
        } else {
            delta = k;
            iMax = n - k;
        }
        long ans = delta + 1L;
        long i = 2L;
        while (i <= iMax) {
            ans = ans * (delta + i) / i;
            ++i;
        }
        return ans;
    }

    public long Choose() {
        long iMax;
        long delta;
        if (this.n < this.k) {
            return 0L;
        }
        if (this.n == this.k) {
            return 1L;
        }
        if (this.k < this.n - this.k) {
            delta = this.n - this.k;
            iMax = this.k;
        } else {
            delta = this.k;
            iMax = this.n - this.k;
        }
        long ans = delta + 1L;
        long i = 2L;
        while (i <= iMax) {
            ans = ans * (delta + i) / i;
            ++i;
        }
        return ans;
    }

    public Combination Successor() {
        if (this.data.length == 0 || this.data[0] == this.n - this.k) {
            return null;
        }
        Combination ans = new Combination(this.n, this.k);
        long i = 0L;
        while (i < this.k) {
            ans.data[(int)i] = this.data[(int)i];
            ++i;
        }
        i = this.k - 1L;
        while (i > 0L && ans.data[(int)i] == this.n - this.k + i) {
            --i;
        }
        int n = (int)i;
        ans.data[n] = ans.data[n] + 1L;
        long j = i;
        while (j < this.k - 1L) {
            ans.data[(int)j + 1] = ans.data[(int)j] + 1L;
            ++j;
        }
        return ans;
    }

    public String ToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        long i = 0L;
        while (i < this.k) {
            sb.append(this.data[(int)i]);
            if (i < this.k - 1L) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

