/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.datastructure;

import java.util.ArrayList;
import java.util.HashMap;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.BasicChannel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.OSMNode;

public class Channel
extends BasicChannel {
    private int indegree;
    private int outdegree;
    private boolean subgraph;
    private int visited = -1;
    private final ArrayList<Channel> reachableNodes = new ArrayList();
    private int ennr;
    private boolean isStrongConnected = true;
    private boolean isSelected = false;
    private boolean isPartOfJunction = false;
    private final HashMap<Channel, ArrayList<Channel>> paths2 = new HashMap();

    public Channel(OSMNode fromNode, OSMNode toNode) {
        this.setFromNode(fromNode);
        this.setToNode(toNode);
        this.subgraph = false;
        this.indegree = 0;
        this.outdegree = 0;
    }

    public Channel() {
        this.subgraph = false;
        this.indegree = 0;
        this.outdegree = 0;
    }

    public int getIndegree() {
        return this.indegree;
    }

    public int getOutdegree() {
        return this.outdegree;
    }

    public void setIndegree(int i) {
        this.indegree = i;
    }

    public void setOutdegree(int i) {
        this.outdegree = i;
    }

    public boolean isSubgraph() {
        return this.subgraph;
    }

    public void setSubgraph(boolean subgraph) {
        this.subgraph = subgraph;
    }

    public int getVisited() {
        return this.visited;
    }

    public void setVisited(int visited) {
        this.visited = visited;
    }

    public ArrayList<Channel> getReachableNodes() {
        return this.reachableNodes;
    }

    public int getEnnr() {
        return this.ennr;
    }

    public void setEnnr(int ennr) {
        this.ennr = ennr;
    }

    public void countupIndegree() {
        ++this.indegree;
    }

    public void countupOutdegree() {
        ++this.outdegree;
    }

    public void addReachableNode(Channel node) {
        if (!this.reachableNodes.contains(node)) {
            this.reachableNodes.add(node);
            this.paths2.put(node, new ArrayList());
        }
    }

    public Channel getReachableNodeAt(int i) {
        return this.reachableNodes.get(i);
    }

    public void ereaseReachableNodes() {
        this.reachableNodes.clear();
    }

    public void setEnnrZero() {
        this.ennr = 0;
    }

    public void increaseEnnr() {
        ++this.ennr;
    }

    public void appendPath(Channel node, ArrayList<Channel> path) {
        int i = 0;
        while (i < path.size()) {
            if (!this.paths2.get(node).contains(path.get(i))) {
                this.paths2.get(node).add(path.get(i));
            }
            ++i;
        }
    }

    public void appendChannelToPath(Channel node, Channel channel) {
        if (!this.paths2.containsKey(node)) {
            this.paths2.put(node, new ArrayList());
        }
        if (!this.paths2.get(node).contains(channel)) {
            this.paths2.get(node).add(channel);
        }
    }

    public ArrayList<ArrayList<Channel>> getPaths() {
        ArrayList<ArrayList<Channel>> t = new ArrayList<ArrayList<Channel>>();
        t.addAll(this.paths2.values());
        return t;
    }

    public ArrayList<Channel> getPathsAt(Channel node) {
        if (this.paths2.containsKey(node)) {
            return this.paths2.get(node);
        }
        return null;
    }

    public boolean isStrongConnected() {
        return this.isStrongConnected;
    }

    public void setStrongConnected(boolean isStrongConnected) {
        this.isStrongConnected = isStrongConnected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public boolean isPartOfJunction() {
        return this.isPartOfJunction;
    }

    public void setPartOfJunction(boolean isPartOfJunction) {
        this.isPartOfJunction = isPartOfJunction;
    }
}

