/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.tools.I18n;
import org.wikipedia.WikipediaApp;

public class WikipediaAddNamesAction
extends JosmAction {
    public WikipediaAddNamesAction() {
        super(I18n.tr((String)"Add names from Wikipedia", (Object[])new Object[0]), "dialogs/wikipedia", I18n.tr((String)"Fetches interwiki links from Wikipedia in order to add several name tags", (Object[])new Object[0]), null, true);
    }

    public void actionPerformed(ActionEvent e) {
        String[] parts = this.getWikipediaValue().split(":", 2);
        ArrayList<String[]> tags = new ArrayList<String[]>();
        for (WikipediaApp.WikipediaLangArticle i : WikipediaApp.getInterwikiArticles(parts[0], parts[1])) {
            if (!this.useWikipediaLangArticle(i)) continue;
            tags.add(new String[]{"name:" + i.lang, i.article});
        }
        System.out.println(tags);
        AddTagsDialog.addTags((String[][])((String[][])tags.toArray((T[])new String[tags.size()][])), (String)"Wikipedia");
    }

    protected boolean useWikipediaLangArticle(WikipediaApp.WikipediaLangArticle i) {
        return !(Main.pref.getBoolean("wikipedia.filter-iso-languages", true) && !Arrays.asList(Locale.getISOLanguages()).contains(i.lang) || Main.pref.getBoolean("wikipedia.filter-same-names", true) && i.article.equals(((OsmPrimitive)WikipediaAddNamesAction.getCurrentDataSet().getSelected().iterator().next()).get("name")));
    }

    protected String getWikipediaValue() {
        if (WikipediaAddNamesAction.getCurrentDataSet() == null || WikipediaAddNamesAction.getCurrentDataSet().getSelected() == null || WikipediaAddNamesAction.getCurrentDataSet().getSelected().size() != 1) {
            return null;
        }
        return ((OsmPrimitive)WikipediaAddNamesAction.getCurrentDataSet().getSelected().iterator().next()).get("wikipedia");
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getWikipediaValue() != null);
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledState();
    }
}

