/*
 * Decompiled with CFR 0.152.
 */
package terracer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.tools.I18n;
import terracer.HouseNumberInputDialog;
import terracer.TerracerAction;

public class HouseNumberInputHandler
extends JosmAction
implements ActionListener,
FocusListener,
ItemListener {
    private final TerracerAction terracerAction;
    private final Way outline;
    private final Way street;
    private final String streetName;
    private final Node init;
    private final Relation associatedStreet;
    private final ArrayList<Node> housenumbers;
    public HouseNumberInputDialog dialog;

    public HouseNumberInputHandler(TerracerAction terracerAction, Way outline, Node init, Way street, String streetName, Relation associatedStreet, ArrayList<Node> housenumbers, String title) {
        this.terracerAction = terracerAction;
        this.outline = outline;
        this.init = init;
        this.street = street;
        this.streetName = streetName;
        this.associatedStreet = associatedStreet;
        this.housenumbers = housenumbers;
        this.dialog = new HouseNumberInputDialog(this, street, streetName, associatedStreet != null, housenumbers);
    }

    private static JButton getButton(Container root, String caption) {
        Component[] children;
        for (Component child : children = root.getComponents()) {
            JButton b;
            if (!(child instanceof JButton ? caption.equals((b = (JButton)child).getText()) : child instanceof Container && (b = HouseNumberInputHandler.getButton((Container)child, caption)) != null)) continue;
            return b;
        }
        return null;
    }

    private boolean validateInput() {
        boolean isOk = true;
        StringBuffer message = new StringBuffer();
        isOk = isOk && this.checkNumberOrder(message);
        isOk = isOk && this.checkSegmentsFromHousenumber(message);
        boolean bl = isOk = isOk && this.checkSegments(message);
        if (this.dialog.hi.getText().length() > 0 && (this.segments() != null || this.segments() < 1)) {
            isOk = isOk && this.checkNumberStringField(this.dialog.lo, I18n.tr((String)"Lowest number", (Object[])new Object[0]), message);
        }
        isOk = isOk && this.checkNumberStringField(this.dialog.hi, I18n.tr((String)"Highest number", (Object[])new Object[0]), message);
        boolean bl2 = isOk = isOk && this.checkNumberStringField(this.dialog.segments, I18n.tr((String)"Segments", (Object[])new Object[0]), message);
        if (isOk) {
            JButton okButton = HouseNumberInputHandler.getButton((Container)((Object)this.dialog), "OK");
            if (okButton != null) {
                okButton.setEnabled(true);
            }
            this.dialog.messageLabel.setForeground(Color.black);
            this.dialog.messageLabel.setText(I18n.tr((String)HouseNumberInputDialog.DEFAULT_MESSAGE, (Object[])new Object[0]));
            return true;
        }
        JButton okButton = HouseNumberInputHandler.getButton((Container)((Object)this.dialog), "OK");
        if (okButton != null) {
            okButton.setEnabled(false);
        }
        this.dialog.messageLabel.setForeground(Color.red);
        this.dialog.messageLabel.setText(message.toString());
        return false;
    }

    private boolean checkNumberOrder(StringBuffer message) {
        if (this.numberFrom() != null && this.numberTo() != null && this.numberFrom() > this.numberTo()) {
            this.appendMessageNewLine(message);
            message.append(I18n.tr((String)"Lowest housenumber cannot be higher than highest housenumber", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkSegmentsFromHousenumber(StringBuffer message) {
        if (!this.dialog.numbers.isVisible()) {
            this.dialog.segments.setEditable(true);
            if (this.numberFrom() != null && this.numberTo() != null) {
                int segments = this.numberTo() - this.numberFrom();
                if (segments % this.stepSize() != 0) {
                    this.appendMessageNewLine(message);
                    message.append(I18n.tr((String)"Housenumbers do not match odd/even setting", (Object[])new Object[0]));
                    return false;
                }
                int steps = segments / this.stepSize();
                this.dialog.segments.setText(String.valueOf(++steps));
                this.dialog.segments.setEditable(false);
            }
        }
        return true;
    }

    private boolean checkSegments(StringBuffer message) {
        if (this.segments() == null || this.segments() < 1) {
            this.appendMessageNewLine(message);
            message.append(I18n.tr((String)"Segment must be a number greater 1", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkNumberStringField(JTextField field, String label, StringBuffer message) {
        String content = field.getText();
        if (content != null && content.length() != 0) {
            try {
                int i = Integer.parseInt(content);
                if (i < 0) {
                    this.appendMessageNewLine(message);
                    message.append(I18n.tr((String)"{0} must be greater than 0", (Object[])new Object[]{label}));
                    return false;
                }
            }
            catch (NumberFormatException e) {
                this.appendMessageNewLine(message);
                message.append(I18n.tr((String)"{0} is not a number", (Object[])new Object[]{label}));
                return false;
            }
        }
        return true;
    }

    private void appendMessageNewLine(StringBuffer message) {
        if (message.length() > 0) {
            message.append("\n");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.validateInput();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton button = (JButton)e.getSource();
            if (I18n.tr((String)"OK", (Object[])new Object[0]).equals(button.getActionCommand()) & button.isEnabled()) {
                if (this.validateInput()) {
                    this.saveValues();
                    try {
                        this.terracerAction.terraceBuilding(this.outline, this.init, this.street, this.associatedStreet, this.segments(), this.dialog.lo.getText(), this.dialog.hi.getText(), this.stepSize(), this.housenumbers, this.streetName(), this.doHandleRelation(), this.doDeleteOutline());
                    }
                    catch (UserCancelException userCancelException) {
                        // empty catch block
                    }
                    this.dialog.dispose();
                }
            } else if (I18n.tr((String)"Cancel", (Object[])new Object[0]).equals(button.getActionCommand())) {
                this.dialog.dispose();
            }
        } else {
            this.validateInput();
        }
    }

    public Integer stepSize() {
        return this.dialog.interpolation.getSelectedItem().equals(I18n.tr((String)"All", (Object[])new Object[0])) ? 1 : 2;
    }

    public Integer segments() {
        try {
            return Integer.parseInt(this.dialog.segments.getText());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Integer numberFrom() {
        try {
            return Integer.parseInt(this.dialog.lo.getText());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public Integer numberTo() {
        try {
            return Integer.parseInt(this.dialog.hi.getText());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public String streetName() {
        if (this.streetName != null) {
            return this.streetName;
        }
        Object selected = this.dialog.streetComboBox.getSelectedItem();
        if (selected == null) {
            return null;
        }
        String name = selected instanceof AutoCompletionListItem ? ((AutoCompletionListItem)selected).getValue() : selected.toString();
        if (name.length() == 0) {
            return null;
        }
        return name;
    }

    public boolean doHandleRelation() {
        if (this.dialog == null) {
            JOptionPane.showMessageDialog(null, "dialog", "alert", 0);
        }
        if (this.dialog.handleRelationCheckBox == null) {
            JOptionPane.showMessageDialog(null, "checkbox", "alert", 0);
            return true;
        }
        return this.dialog.handleRelationCheckBox.isSelected();
    }

    public boolean doDeleteOutline() {
        return this.dialog.deleteOutlineCheckBox.isSelected();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getOppositeComponent() == null) {
            return;
        }
        this.validateInput();
    }

    public void saveValues() {
        Main.pref.put("plugins.terracer.handle_relation", this.doHandleRelation());
        Main.pref.put("plugins.terracer.delete_outline", this.doDeleteOutline());
        Main.pref.put("plugins.terracer.interpolation", this.stepSize().toString());
    }
}

