/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.tabular;

import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.io.ProjectionChooser;
import org.openstreetmap.josm.plugins.opendata.core.io.ProjectionPatterns;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetHandler;
import org.openstreetmap.josm.tools.I18n;

public abstract class SpreadSheetReader
extends AbstractReader
implements OdConstants {
    private static final NumberFormat formatFrance = NumberFormat.getInstance(Locale.FRANCE);
    private static final NumberFormat formatUK = NumberFormat.getInstance(Locale.UK);
    protected final SpreadSheetHandler handler;

    public SpreadSheetReader(SpreadSheetHandler handler) {
        this.handler = handler;
    }

    protected static double parseDouble(String value) throws ParseException {
        if (value.contains(",")) {
            return formatFrance.parse(value.replace(" ", "")).doubleValue();
        }
        return formatUK.parse(value.replace(" ", "")).doubleValue();
    }

    protected abstract void initResources(InputStream var1, ProgressMonitor var2) throws IOException;

    protected abstract String[] readLine(ProgressMonitor var1) throws IOException;

    protected final int getSheetNumber() {
        return this.handler != null && this.handler.getSheetNumber() > -1 ? this.handler.getSheetNumber() : 0;
    }

    protected final int getLineNumber() {
        return this.handler != null ? this.handler.getLineNumber() : -1;
    }

    private final CoordinateColumns addCoorColIfNeeded(List<CoordinateColumns> columns, CoordinateColumns col) {
        if (col == null || col.isOk()) {
            col = new CoordinateColumns();
            columns.add(col);
        }
        return col;
    }

    public DataSet doParse(String[] header, ProgressMonitor progressMonitor) throws IOException {
        String[] fields;
        System.out.println("Header: " + Arrays.toString(header));
        HashMap<ProjectionPatterns, ArrayList<CoordinateColumns>> projColumns = new HashMap<ProjectionPatterns, ArrayList<CoordinateColumns>>();
        block2: for (int i = 0; i < header.length; ++i) {
            for (ProjectionPatterns pp : PROJECTIONS) {
                CoordinateColumns col;
                ArrayList<CoordinateColumns> columns = (ArrayList<CoordinateColumns>)projColumns.get(pp);
                if (columns == null) {
                    columns = new ArrayList<CoordinateColumns>();
                    projColumns.put(pp, columns);
                }
                CoordinateColumns coordinateColumns = col = columns.isEmpty() ? null : (CoordinateColumns)columns.get(columns.size() - 1);
                if (pp.getXPattern().matcher(header[i]).matches()) {
                    this.addCoorColIfNeeded(columns, (CoordinateColumns)col).xCol = i;
                    continue block2;
                }
                if (!pp.getYPattern().matcher(header[i]).matches()) continue;
                this.addCoorColIfNeeded(columns, (CoordinateColumns)col).yCol = i;
                continue block2;
            }
        }
        ArrayList<CoordinateColumns> columns = new ArrayList<CoordinateColumns>();
        for (ProjectionPatterns pp : projColumns.keySet()) {
            for (CoordinateColumns col : (List)projColumns.get(pp)) {
                if (!col.isOk()) continue;
                columns.add(col);
                if (col.proj != null) continue;
                col.proj = pp.getProjection(header[col.xCol], header[col.yCol]);
            }
        }
        boolean handlerOK = this.handler != null && this.handler.handlesProjection();
        boolean projFound = false;
        for (CoordinateColumns c : columns) {
            if (c.proj == null) continue;
            projFound = true;
            break;
        }
        if (!projFound) {
            if (!columns.isEmpty()) {
                if (!handlerOK) {
                    ProjectionChooser dialog = (ProjectionChooser)new ProjectionChooser(progressMonitor.getWindowParent()).showDialog();
                    if (dialog.getValue() != 1) {
                        return null;
                    }
                    Projection proj = dialog.getProjection();
                    for (CoordinateColumns c : columns) {
                        c.proj = proj;
                    }
                }
            } else {
                throw new IllegalArgumentException(I18n.tr((String)"No valid coordinates have been found.", (Object[])new Object[0]));
            }
        }
        String message = "";
        for (CoordinateColumns c : columns) {
            if (!message.isEmpty()) {
                message = message + "; ";
            }
            message = message + c.proj + "(" + header[c.xCol] + ", " + header[c.yCol] + ")";
        }
        System.out.println("Loading data using projections " + message);
        DataSet ds = new DataSet();
        int lineNumber = 1;
        while ((fields = this.readLine(progressMonitor)) != null) {
            EastNorth en;
            ++lineNumber;
            if (this.handler != null) {
                this.handler.setXCol(-1);
                this.handler.setYCol(-1);
            }
            HashMap<CoordinateColumns, EastNorth> ens = new HashMap<CoordinateColumns, EastNorth>();
            HashMap<CoordinateColumns, Node> nodes = new HashMap<CoordinateColumns, Node>();
            for (CoordinateColumns c : columns) {
                nodes.put(c, new Node());
                ens.put(c, new EastNorth(Double.NaN, Double.NaN));
            }
            for (int i = 0; i < fields.length; ++i) {
                try {
                    if (i >= header.length) {
                        throw new IllegalArgumentException(I18n.tr((String)"Invalid file. Bad length on line {0}. Expected {1} columns, got {2}.", (Object[])new Object[]{lineNumber, header.length, i + 1}));
                    }
                    boolean coordinate = false;
                    for (CoordinateColumns c : columns) {
                        en = (EastNorth)ens.get(c);
                        if (i == c.xCol) {
                            coordinate = true;
                            en.setLocation(SpreadSheetReader.parseDouble(fields[i]), en.north());
                            if (this.handler == null) continue;
                            this.handler.setXCol(i);
                            continue;
                        }
                        if (i != c.yCol) continue;
                        coordinate = true;
                        en.setLocation(en.east(), SpreadSheetReader.parseDouble(fields[i]));
                        if (this.handler == null) continue;
                        this.handler.setYCol(i);
                    }
                    if (coordinate || fields[i].isEmpty()) continue;
                    ((Node)nodes.values().iterator().next()).put(header[i], fields[i]);
                    continue;
                }
                catch (ParseException e) {
                    System.err.println("Warning: Parsing error on line " + lineNumber + ": " + e.getMessage());
                }
            }
            Node firstNode = null;
            for (CoordinateColumns c : columns) {
                Node n = (Node)nodes.get(c);
                en = (EastNorth)ens.get(c);
                if (en.isValid()) {
                    n.setCoor(c.proj != null && !handlerOK ? c.proj.eastNorth2latlon(en) : this.handler.getCoor(en, fields));
                } else {
                    System.err.println("Warning: Skipping line " + lineNumber + " because no valid coordinates have been found at columns " + c);
                }
                if (n.getCoor() == null) continue;
                if (firstNode == null) {
                    firstNode = n;
                }
                if (n == firstNode || n.getCoor().greatCircleDistance(firstNode.getCoor()) > Main.pref.getDouble("opendata.spreadsheet.tolerance", 0.1)) {
                    ds.addPrimitive((OsmPrimitive)n);
                    continue;
                }
                nodes.remove(c);
            }
            if (this.handler == null || Main.pref.getBoolean("opendata.rawdata")) continue;
            this.handler.nodesAdded(ds, nodes, header, lineNumber);
        }
        return ds;
    }

    public final DataSet parse(InputStream in, ProgressMonitor progressMonitor) throws IOException {
        this.initResources(in, progressMonitor);
        String[] header = null;
        int length = 0;
        int n = 0;
        while (header == null || length == 0) {
            header = this.readLine(progressMonitor);
            length = 0;
            if (header == null && ++n > this.getLineNumber()) {
                return null;
            }
            if (header == null || this.getLineNumber() != -1 && this.getLineNumber() != n) continue;
            for (String field : header) {
                length += field.length();
            }
        }
        return this.doParse(header, progressMonitor);
    }

    public static class CoordinateColumns {
        public Projection proj = null;
        public int xCol = -1;
        public int yCol = -1;

        public final boolean isOk() {
            return this.xCol > -1 && this.yCol > -1;
        }

        public String toString() {
            return "CoordinateColumns [proj=" + this.proj + ", xCol=" + this.xCol + ", yCol=" + this.yCol + "]";
        }
    }
}

