/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.TabFiles;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.AbstractMapInfoReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.SpreadSheetReader;

public class TabReader
extends AbstractMapInfoReader {
    private Charset datCharset;
    private final AbstractDataSetHandler handler;

    public TabReader(AbstractDataSetHandler handler) {
        this.handler = handler;
    }

    public static DataSet parseDataSet(InputStream in, File file, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException {
        return new TabReader(handler).parse(in, file, instance, Charset.forName("ISO-8859-15"));
    }

    private DataSet parse(InputStream in, File file, ProgressMonitor instance, Charset charset) throws IOException {
        this.headerReader = new BufferedReader(new InputStreamReader(in, charset));
        this.parseHeader();
        try {
            File dataFile = this.getDataFile(file, ".dat");
            this.ds = new TabOsmReader(this.handler != null ? this.handler.getSpreadSheetHandler() : null, new TabFiles(file, dataFile)).doParse(this.columns.toArray(new String[0]), instance);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return this.ds;
    }

    @Override
    protected void parseHeaderLine(String[] words) throws IOException {
        if (!words[0].equalsIgnoreCase("!table")) {
            if (words[0].equalsIgnoreCase("!version")) {
                this.parseVersion(words);
            } else if (words[0].equalsIgnoreCase("!charset")) {
                this.parseCharset(words);
            } else if (this.numcolumns > 0) {
                this.parseField(words);
            } else if (!words[0].equalsIgnoreCase("Definition")) {
                if (words[0].equalsIgnoreCase("Type")) {
                    this.parseType(words);
                } else if (words[0].equalsIgnoreCase("Fields")) {
                    this.parseColumns(words);
                } else if (!this.line.isEmpty()) {
                    System.err.println("Line " + this.lineNum + ". Unknown clause in header: " + this.line);
                }
            }
        }
    }

    private void parseField(String[] words) {
        this.columns.add(words[0]);
        --this.numcolumns;
    }

    private void parseType(String[] words) {
        if (words[1].equalsIgnoreCase("NATIVE") && words[2].equalsIgnoreCase("Charset")) {
            this.datCharset = this.parseCharset(words, 3);
        } else {
            System.err.println("Line " + this.lineNum + ". Unknown Type clause in header: " + this.line);
        }
    }

    private class TabOsmReader
    extends SpreadSheetReader {
        private final DbaseFileReader dbfReader;

        public TabOsmReader(SpreadSheetHandler handler, TabFiles tabFiles) throws IOException {
            super(handler);
            this.dbfReader = new DbaseFileReader((ShpFiles)tabFiles, false, TabReader.this.datCharset, null);
        }

        @Override
        protected void initResources(InputStream in, ProgressMonitor progressMonitor) throws IOException {
        }

        @Override
        protected String[] readLine(ProgressMonitor progressMonitor) throws IOException {
            if (!this.dbfReader.hasNext()) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            DbaseFileReader.Row row = this.dbfReader.readRow();
            for (int i = 0; i < TabReader.this.columns.size(); ++i) {
                Object o = row.read(i);
                if (o != null) {
                    result.add(o.toString());
                    continue;
                }
                result.add("");
            }
            return result.toArray(new String[0]);
        }
    }
}

