/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.io.ProjectionPatterns;

public class KmlReader
extends AbstractReader
implements OdConstants {
    public static final String KML_PLACEMARK = "Placemark";
    public static final String KML_NAME = "name";
    public static final String KML_COLOR = "color";
    public static final String KML_SIMPLE_DATA = "SimpleData";
    public static final String KML_LINE_STRING = "LineString";
    public static final String KML_POINT = "Point";
    public static final String KML_POLYGON = "Polygon";
    public static final String KML_OUTER_BOUND = "outerBoundaryIs";
    public static final String KML_INNER_BOUND = "innerBoundaryIs";
    public static final String KML_LINEAR_RING = "LinearRing";
    public static final String KML_COORDINATES = "coordinates";
    private XMLStreamReader parser;
    private Map<LatLon, Node> nodes = new HashMap<LatLon, Node>();

    public KmlReader(XMLStreamReader parser) {
        this.parser = parser;
    }

    public static DataSet parseDataSet(InputStream in, ProgressMonitor instance) throws IOException, XMLStreamException, FactoryConfigurationError {
        UTFInputStreamReader ir = UTFInputStreamReader.create((InputStream)in, (String)"UTF-8");
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader((Reader)ir);
        return new KmlReader(parser).parseDoc();
    }

    private DataSet parseDoc() throws XMLStreamException {
        DataSet ds = new DataSet();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event != 1 || !this.parser.getLocalName().equals(KML_PLACEMARK)) continue;
            this.parsePlaceMark(ds);
        }
        return ds;
    }

    private static boolean keyIsIgnored(String key) {
        for (ProjectionPatterns pp : PROJECTIONS) {
            if (!pp.getXPattern().matcher(key).matches() && !pp.getYPattern().matcher(key).matches()) continue;
            return true;
        }
        return false;
    }

    private void parsePlaceMark(DataSet ds) throws XMLStreamException {
        ArrayList<Object> list = new ArrayList<Object>();
        Way way = null;
        Node node = null;
        Relation relation = null;
        String role = "";
        HashMap<String, String> tags = new HashMap<String, String>();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                if (this.parser.getLocalName().equals(KML_COLOR)) {
                    String string = this.parser.getElementText();
                    String rgbColor = '#' + string.substring(6, 8) + string.substring(4, 6) + string.substring(2, 4);
                    tags.put(KML_COLOR, rgbColor);
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_NAME)) {
                    tags.put(KML_NAME, this.parser.getElementText());
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_SIMPLE_DATA)) {
                    String string = this.parser.getAttributeValue(null, KML_NAME);
                    if (KmlReader.keyIsIgnored(string)) continue;
                    tags.put(string, this.parser.getElementText());
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_POLYGON)) {
                    relation = new Relation();
                    ds.addPrimitive((OsmPrimitive)relation);
                    relation.put("type", "multipolygon");
                    list.add(relation);
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_OUTER_BOUND)) {
                    role = "outer";
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_INNER_BOUND)) {
                    role = "inner";
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_LINEAR_RING)) {
                    if (relation == null) continue;
                    way = new Way();
                    ds.addPrimitive((OsmPrimitive)way);
                    relation.addMember(new RelationMember(role, (OsmPrimitive)way));
                    continue;
                }
                if (this.parser.getLocalName().equals(KML_LINE_STRING)) {
                    way = new Way();
                    ds.addPrimitive((OsmPrimitive)way);
                    list.add(way);
                    continue;
                }
                if (!this.parser.getLocalName().equals(KML_COORDINATES)) continue;
                String[] stringArray = this.parser.getElementText().trim().split("\\s");
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] values = stringArray[i].split(",");
                    if (values.length < 2) continue;
                    LatLon ll = new LatLon(Double.valueOf(values[1]).doubleValue(), Double.valueOf(values[0]).doubleValue()).getRoundedToOsmPrecisionStrict();
                    node = this.nodes.get(ll);
                    if (node == null) {
                        node = new Node(ll);
                        ds.addPrimitive((OsmPrimitive)node);
                        this.nodes.put(ll, node);
                        if (values.length > 2 && !values[2].equals("0")) {
                            node.put("ele", values[2]);
                        }
                    }
                    if (way == null) continue;
                    way.addNode(node);
                }
                continue;
            }
            if (event != 2) continue;
            if (this.parser.getLocalName().equals(KML_PLACEMARK)) break;
            if (!this.parser.getLocalName().equals(KML_POINT)) continue;
            list.add(node);
        }
        for (OsmPrimitive osmPrimitive : list) {
            for (String key : tags.keySet()) {
                osmPrimitive.put(key, (String)tags.get(key));
            }
        }
    }
}

