/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.util.Arrays;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.poifs.property.Child;
import org.apache.poi.util.ByteField;
import org.apache.poi.util.IntegerField;
import org.apache.poi.util.ShortField;

public abstract class Property
implements Child {
    private static final byte _default_fill = 0;
    private static final int _name_size_offset = 64;
    private static final int _max_name_length = 31;
    protected static final int _NO_INDEX = -1;
    private static final int _node_color_offset = 67;
    private static final int _previous_property_offset = 68;
    private static final int _next_property_offset = 72;
    private static final int _child_property_offset = 76;
    private static final int _storage_clsid_offset = 80;
    private static final int _start_block_offset = 116;
    private static final int _size_offset = 120;
    protected static final byte _NODE_BLACK = 1;
    private static final int _big_block_minimum_bytes = 4096;
    private String _name;
    private ShortField _name_size;
    private ByteField _property_type;
    private ByteField _node_color;
    private IntegerField _previous_property;
    private IntegerField _next_property;
    private IntegerField _child_property;
    private ClassID _storage_clsid;
    private IntegerField _start_block;
    private IntegerField _size;
    private byte[] _raw_data = new byte[128];
    private int _index;

    protected Property() {
        Arrays.fill(this._raw_data, (byte)0);
        this._name_size = new ShortField(64);
        this._property_type = new ByteField(66);
        this._node_color = new ByteField(67);
        this._previous_property = new IntegerField(68, -1, this._raw_data);
        this._next_property = new IntegerField(72, -1, this._raw_data);
        this._child_property = new IntegerField(76, -1, this._raw_data);
        this._storage_clsid = new ClassID(this._raw_data, 80);
        this._start_block = new IntegerField(116);
        this._size = new IntegerField(120, 0, this._raw_data);
        this._index = -1;
        this.setName("");
        this.setNextChild(null);
        this.setPreviousChild(null);
    }

    protected Property(int n, byte[] byArray, int n2) {
        System.arraycopy(byArray, n2, this._raw_data, 0, 128);
        this._name_size = new ShortField(64, this._raw_data);
        this._property_type = new ByteField(66, this._raw_data);
        this._node_color = new ByteField(67, this._raw_data);
        this._previous_property = new IntegerField(68, this._raw_data);
        this._next_property = new IntegerField(72, this._raw_data);
        this._child_property = new IntegerField(76, this._raw_data);
        this._storage_clsid = new ClassID(this._raw_data, 80);
        this._start_block = new IntegerField(116, this._raw_data);
        this._size = new IntegerField(120, this._raw_data);
        this._index = n;
        int n3 = this._name_size.get() / 2 - 1;
        if (n3 < 1) {
            this._name = "";
        } else {
            char[] cArray = new char[n3];
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                cArray[i] = (char)new ShortField(n4, this._raw_data).get();
                n4 += 2;
            }
            this._name = new String(cArray, 0, n3);
        }
    }

    public void setStartBlock(int n) {
        this._start_block.set(n, this._raw_data);
    }

    public int getStartBlock() {
        return this._start_block.get();
    }

    public int getSize() {
        return this._size.get();
    }

    public boolean shouldUseSmallBlocks() {
        return Property.isSmall(this._size.get());
    }

    public static boolean isSmall(int n) {
        return n < 4096;
    }

    public String getName() {
        return this._name;
    }

    public abstract boolean isDirectory();

    public ClassID getStorageClsid() {
        return this._storage_clsid;
    }

    protected void setName(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = Math.min(cArray.length, 31);
        this._name = new String(cArray, 0, n2);
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            new ShortField(n3, (short)cArray[n], this._raw_data);
            n3 = (short)(n3 + 2);
        }
        while (n < 32) {
            new ShortField(n3, 0, this._raw_data);
            n3 = (short)(n3 + 2);
            ++n;
        }
        this._name_size.set((short)((n2 + 1) * 2), this._raw_data);
    }

    public void setStorageClsid(ClassID classID) {
        this._storage_clsid = classID;
        if (classID == null) {
            Arrays.fill(this._raw_data, 80, 96, (byte)0);
        } else {
            classID.write(this._raw_data, 80);
        }
    }

    protected void setPropertyType(byte by) {
        this._property_type.set(by, this._raw_data);
    }

    protected void setNodeColor(byte by) {
        this._node_color.set(by, this._raw_data);
    }

    protected void setChildProperty(int n) {
        this._child_property.set(n, this._raw_data);
    }

    protected int getChildIndex() {
        return this._child_property.get();
    }

    protected void setSize(int n) {
        this._size.set(n, this._raw_data);
    }

    protected int getIndex() {
        return this._index;
    }

    protected abstract void preWrite();

    int getNextChildIndex() {
        return this._next_property.get();
    }

    int getPreviousChildIndex() {
        return this._previous_property.get();
    }

    static boolean isValidIndex(int n) {
        return n != -1;
    }

    @Override
    public void setNextChild(Child child) {
        this._next_property.set(child == null ? -1 : ((Property)child).getIndex(), this._raw_data);
    }

    @Override
    public void setPreviousChild(Child child) {
        this._previous_property.set(child == null ? -1 : ((Property)child).getIndex(), this._raw_data);
    }
}

