/*
 * Decompiled with CFR 0.152.
 */
package smed.menu.file;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import smed.io.SmedFile;
import smed.jide.swing.CheckBoxList;
import smed.jide.swing.CheckBoxListSelectionModel;
import smed.plug.ifc.SmedPluggable;
import smed.tabs.SmedTabbedPane;

public class TabManager
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DefaultListModel model = new DefaultListModel();
    private CheckBoxListSelectionModel selModel;
    private List<SmedPluggable> plugins = SmedTabbedPane.getPlugins();
    private SmedFile splugDir = null;
    private int modelSize = 0;
    private JDialog tabManagerDialog = null;
    private JPanel tabManagerPanel = null;
    private JScrollPane tabScrollPane = null;
    private CheckBoxList tabList = null;
    private JButton tabButtonOk = null;
    private JButton tabButtonCancel = null;
    private JButton tabButtonUndo = null;
    private JButton tabButtonLoad = null;
    private JButton tabButtonSave = null;
    private JButton tabButtonDelete = null;
    private JButton tabButtonVisible = null;
    private JButton tabButtonAll = null;
    private JButton tabButtonNone = null;
    private JLabel tabLabelSelect = null;
    private JLabel tabLabelRename = null;
    private JTextField tabTextFieldRename = null;

    public TabManager() {
        String pluginDirName = Main.pref.getPluginsDirectory().getAbsolutePath();
        this.splugDir = new SmedFile(pluginDirName + "/splug");
        if (this.plugins != null) {
            for (SmedPluggable p : this.plugins) {
                if (this.splugDir.isVisible(p.getFileName()) && !this.splugDir.isDeleted(p.getFileName())) {
                    this.model.addElement(p.getName());
                    continue;
                }
                if (this.splugDir.isDeleted(p.getFileName())) {
                    this.model.addElement("delete - " + p.getName());
                    continue;
                }
                this.model.addElement("invisible - " + p.getName());
            }
        } else {
            this.model.addElement("no plugin loaded");
        }
        this.modelSize = this.model.getSize();
        this.getTabManagerDialog().setVisible(true);
    }

    private JDialog getTabManagerDialog() {
        if (this.tabManagerDialog == null) {
            this.tabManagerDialog = new JDialog(this);
            this.tabManagerDialog.setSize(new Dimension(409, 442));
            this.tabManagerDialog.setResizable(false);
            this.tabManagerDialog.setModal(true);
            this.tabManagerDialog.setContentPane(this.getTabManagerPanel());
            this.tabManagerDialog.setTitle("Tabmanager");
        }
        return this.tabManagerDialog;
    }

    private JPanel getTabManagerPanel() {
        if (this.tabManagerPanel == null) {
            this.tabLabelRename = new JLabel();
            this.tabLabelRename.setBounds(new Rectangle(15, 334, 70, 25));
            this.tabLabelRename.setText("Rename:");
            this.tabLabelSelect = new JLabel();
            this.tabLabelSelect.setBounds(new Rectangle(16, 304, 72, 15));
            this.tabLabelSelect.setFont(new Font("Dialog", 0, 12));
            this.tabLabelSelect.setText("Select:");
            this.tabManagerPanel = new JPanel();
            this.tabManagerPanel.setLayout(null);
            this.tabManagerPanel.setOpaque(true);
            this.tabManagerPanel.add((Component)this.getTabScrollPane(), null);
            this.tabManagerPanel.add((Component)this.getTabButtonOk(), null);
            this.tabManagerPanel.add((Component)this.getTabButtonCancel(), null);
            this.tabManagerPanel.add((Component)this.getTabButtonUndo(), null);
            this.tabManagerPanel.add((Component)this.getTabButtonLoad(), null);
            this.tabManagerPanel.add((Component)this.getTabButtonSave(), null);
            this.tabManagerPanel.add((Component)this.getTabButtonDelete(), null);
            this.tabManagerPanel.add((Component)this.getTabButtonVisible(), null);
            this.tabManagerPanel.add((Component)this.getTabButtonAll(), null);
            this.tabManagerPanel.add((Component)this.getTabButtonNone(), null);
            this.tabManagerPanel.add((Component)this.tabLabelSelect, null);
            this.tabManagerPanel.add((Component)this.tabLabelRename, null);
            this.tabManagerPanel.add((Component)this.getTabTextFieldRename(), null);
        }
        return this.tabManagerPanel;
    }

    private JScrollPane getTabScrollPane() {
        if (this.tabScrollPane == null) {
            this.tabScrollPane = new JScrollPane();
            this.tabScrollPane.setBounds(new Rectangle(15, 8, 225, 285));
            this.tabScrollPane.setViewportView(this.getTabList());
            this.tabScrollPane.setVerticalScrollBarPolicy(20);
        }
        return this.tabScrollPane;
    }

    private CheckBoxList getTabList() {
        if (this.tabList == null) {
            this.tabList = new CheckBoxList((ListModel)this.model);
            this.selModel = this.tabList.getCheckBoxListSelectionModel();
        }
        return this.tabList;
    }

    private JButton getTabButtonOk() {
        if (this.tabButtonOk == null) {
            this.tabButtonOk = new JButton();
            this.tabButtonOk.setBounds(new Rectangle(254, 4, 130, 30));
            this.tabButtonOk.setFont(new Font("Dialog", 1, 12));
            this.tabButtonOk.setText("Ok");
            this.tabButtonOk.addActionListener(this);
            this.tabButtonOk.setActionCommand("ok");
        }
        return this.tabButtonOk;
    }

    private JButton getTabButtonCancel() {
        if (this.tabButtonCancel == null) {
            this.tabButtonCancel = new JButton();
            this.tabButtonCancel.setBounds(new Rectangle(254, 44, 130, 30));
            this.tabButtonCancel.setFont(new Font("Dialog", 1, 12));
            this.tabButtonCancel.setText(I18n.tr((String)"Cancel", (Object[])new Object[0]));
            this.tabButtonCancel.addActionListener(this);
            this.tabButtonCancel.setActionCommand("cancel");
        }
        return this.tabButtonCancel;
    }

    private JButton getTabButtonUndo() {
        if (this.tabButtonUndo == null) {
            this.tabButtonUndo = new JButton();
            this.tabButtonUndo.setBounds(new Rectangle(254, 84, 130, 30));
            this.tabButtonUndo.setFont(new Font("Dialog", 1, 12));
            this.tabButtonUndo.setText(I18n.tr((String)"Undo", (Object[])new Object[0]));
            this.tabButtonUndo.addActionListener(this);
            this.tabButtonUndo.setActionCommand("undo");
        }
        return this.tabButtonUndo;
    }

    private JButton getTabButtonLoad() {
        if (this.tabButtonLoad == null) {
            this.tabButtonLoad = new JButton();
            this.tabButtonLoad.setBounds(new Rectangle(186, 328, 104, 30));
            this.tabButtonLoad.setFont(new Font("Dialog", 0, 12));
            this.tabButtonLoad.setText(I18n.tr((String)"Load", (Object[])new Object[0]));
            this.tabButtonLoad.addActionListener(this);
            this.tabButtonLoad.setActionCommand("load");
        }
        return this.tabButtonLoad;
    }

    private JButton getTabButtonSave() {
        if (this.tabButtonSave == null) {
            this.tabButtonSave = new JButton();
            this.tabButtonSave.setBounds(new Rectangle(293, 328, 104, 30));
            this.tabButtonSave.setFont(new Font("Dialog", 0, 12));
            this.tabButtonSave.setText(I18n.tr((String)"Save", (Object[])new Object[0]));
            this.tabButtonSave.addActionListener(this);
            this.tabButtonSave.setActionCommand("save");
        }
        return this.tabButtonSave;
    }

    private JButton getTabButtonDelete() {
        if (this.tabButtonDelete == null) {
            this.tabButtonDelete = new JButton();
            this.tabButtonDelete.setBounds(new Rectangle(186, 362, 104, 30));
            this.tabButtonDelete.setFont(new Font("Dialog", 0, 12));
            this.tabButtonDelete.setText(I18n.tr((String)"Delete", (Object[])new Object[0]));
            this.tabButtonDelete.addActionListener(this);
            this.tabButtonDelete.setActionCommand("delete");
        }
        return this.tabButtonDelete;
    }

    private JButton getTabButtonVisible() {
        if (this.tabButtonVisible == null) {
            this.tabButtonVisible = new JButton();
            this.tabButtonVisible.setBounds(new Rectangle(293, 362, 104, 30));
            this.tabButtonVisible.setFont(new Font("Dialog", 0, 12));
            this.tabButtonVisible.setText(I18n.tr((String)"invisible", (Object[])new Object[0]));
            this.tabButtonVisible.addActionListener(this);
            this.tabButtonVisible.setActionCommand("invisible");
        }
        return this.tabButtonVisible;
    }

    private JButton getTabButtonAll() {
        if (this.tabButtonAll == null) {
            this.tabButtonAll = new JButton();
            this.tabButtonAll.setBounds(new Rectangle(92, 300, 72, 20));
            this.tabButtonAll.setFont(new Font("Dialog", 0, 12));
            this.tabButtonAll.setText(I18n.tr((String)"all", (Object[])new Object[0]));
            this.tabButtonAll.addActionListener(this);
            this.tabButtonAll.setActionCommand("all");
        }
        return this.tabButtonAll;
    }

    private JButton getTabButtonNone() {
        if (this.tabButtonNone == null) {
            this.tabButtonNone = new JButton();
            this.tabButtonNone.setBounds(new Rectangle(166, 300, 72, 20));
            this.tabButtonNone.setFont(new Font("Dialog", 0, 12));
            this.tabButtonNone.setText(I18n.tr((String)"none", (Object[])new Object[0]));
            this.tabButtonNone.addActionListener(this);
            this.tabButtonNone.setActionCommand("none");
        }
        return this.tabButtonNone;
    }

    private JTextField getTabTextFieldRename() {
        if (this.tabTextFieldRename == null) {
            this.tabTextFieldRename = new JTextField();
            this.tabTextFieldRename.setBounds(new Rectangle(14, 362, 167, 32));
        }
        return this.tabTextFieldRename;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ok")) {
            int i = 0;
            JTabbedPane tabbedPane = SmedTabbedPane.getTabbedPane();
            if (this.plugins != null) {
                for (SmedPluggable p : this.plugins) {
                    String str = this.model.get(i).toString();
                    if (str.length() > 9 && str.substring(0, 9).equals("invisible")) {
                        this.splugDir.setVisible(p.getFileName(), false);
                    } else {
                        this.splugDir.setVisible(p.getFileName(), true);
                    }
                    if (str.length() > 6 && str.substring(0, 6).equals("delete")) {
                        this.splugDir.setDeleted(p.getFileName(), true);
                    } else {
                        this.splugDir.setDeleted(p.getFileName(), false);
                    }
                    ++i;
                }
                tabbedPane.removeAll();
                JComponent panel = null;
                ImageIcon icon = null;
                for (SmedPluggable p : this.plugins) {
                    if (!this.splugDir.isVisible(p.getFileName()) || this.splugDir.isDeleted(p.getFileName())) continue;
                    panel = p.getComponent();
                    icon = p.getIcon();
                    tabbedPane.addTab(p.getName(), icon, panel, p.getInfo());
                }
            }
            System.out.println("Aufraeumarbeiten beginnen");
            this.tabManagerDialog.setVisible(false);
            this.tabManagerDialog.dispose();
            return;
        }
        if (cmd.equals("cancel")) {
            this.tabManagerDialog.setVisible(false);
            this.tabManagerDialog.dispose();
            return;
        }
        if (cmd.equals("all")) {
            this.selModel.addSelectionInterval(0, this.modelSize - 1);
            return;
        }
        if (cmd.equals("none")) {
            this.selModel.removeSelectionInterval(0, this.modelSize - 1);
            return;
        }
        if (cmd.equals("invisible")) {
            this.cmd("invisible - ");
        }
        if (cmd.equals("delete")) {
            this.cmd("delete - ");
        }
        if (cmd.equals("undo")) {
            this.cmd("");
        }
    }

    private void cmd(String s) {
        int i = 0;
        if (this.plugins != null) {
            for (SmedPluggable p : this.plugins) {
                if (this.selModel.isSelectedIndex(i)) {
                    this.model.set(i, s + p.getName());
                }
                ++i;
            }
        }
    }
}

