/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.gui.OsbDialog;
import org.openstreetmap.josm.plugins.osb.gui.action.AddCommentAction;
import org.openstreetmap.josm.plugins.osb.gui.action.CloseIssueAction;
import org.openstreetmap.josm.plugins.osb.gui.action.OpenInBrowserAction;
import org.openstreetmap.josm.tools.I18n;

public class PopupFactory {
    private static JPopupMenu issuePopup;
    private static JPopupMenu fixedPopup;

    public static synchronized JPopupMenu createPopup(Node node, OsbDialog dialog) {
        if ("0".equals(node.get("state"))) {
            return PopupFactory.getIssuePopup(dialog);
        }
        if ("1".equals(node.get("state"))) {
            return PopupFactory.getFixedPopup(dialog);
        }
        throw new RuntimeException(I18n.tr((String)"Unknown issue state", (Object[])new Object[0]));
    }

    private static JPopupMenu getIssuePopup(OsbDialog dialog) {
        if (issuePopup == null) {
            issuePopup = new JPopupMenu();
            JMenuItem add = new JMenuItem();
            add.setAction(new AddCommentAction(dialog));
            add.setIcon(OsbPlugin.loadIcon("add_comment16.png"));
            issuePopup.add(add);
            JMenuItem close = new JMenuItem();
            close.setAction(new CloseIssueAction(dialog));
            close.setIcon(OsbPlugin.loadIcon("icon_valid16.png"));
            issuePopup.add(close);
            JMenuItem openInBrowser = new JMenuItem();
            openInBrowser.setAction(new OpenInBrowserAction(dialog));
            openInBrowser.setIcon(OsbPlugin.loadIcon("internet-web-browser.png"));
            issuePopup.add(openInBrowser);
        }
        return issuePopup;
    }

    private static JPopupMenu getFixedPopup(OsbDialog dialog) {
        if (fixedPopup == null) {
            fixedPopup = new JPopupMenu();
            JMenuItem add = new JMenuItem();
            AddCommentAction aca = new AddCommentAction(dialog);
            aca.setEnabled(false);
            add.setAction(aca);
            add.setIcon(OsbPlugin.loadIcon("add_comment16.png"));
            fixedPopup.add(add);
            JMenuItem close = new JMenuItem();
            CloseIssueAction cia = new CloseIssueAction(dialog);
            cia.setEnabled(false);
            close.setAction(cia);
            close.setIcon(OsbPlugin.loadIcon("icon_valid16.png"));
            fixedPopup.add(close);
            JMenuItem openInBrowser = new JMenuItem();
            openInBrowser.setAction(new OpenInBrowserAction(dialog));
            openInBrowser.setIcon(OsbPlugin.loadIcon("internet-web-browser.png"));
            fixedPopup.add(openInBrowser);
        }
        return fixedPopup;
    }
}

