/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.widgets.HistoryChangedListener;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.api.NewAction;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbAction;
import org.openstreetmap.josm.plugins.osb.gui.dialogs.TextInputDialog;
import org.openstreetmap.josm.tools.I18n;

public class NewIssueAction
extends OsbAction {
    private static final long serialVersionUID = 1L;
    private OsbPlugin plugin;
    private String result;
    private Point p;
    private NewAction newAction = new NewAction();

    public NewIssueAction(OsbPlugin plugin, Point p) {
        super(I18n.tr((String)"New issue", (Object[])new Object[0]), plugin.getDialog());
        this.plugin = plugin;
        this.p = p;
    }

    protected void doActionPerformed(ActionEvent e) throws IOException, InterruptedException {
        LinkedList<String> history = new LinkedList<String>(Main.pref.getCollection("osb.new.history", new LinkedList()));
        HistoryChangedListener l = new HistoryChangedListener(){

            public void historyChanged(List<String> history) {
                Main.pref.putCollection("osb.new.history", history);
            }
        };
        this.result = TextInputDialog.showDialog((JComponent)Main.map, I18n.tr((String)"Create issue", (Object[])new Object[0]), I18n.tr((String)"Describe the problem precisely", (Object[])new Object[0]), OsbPlugin.loadIcon("icon_error_add22.png"), history, l);
        if (this.result == null) {
            this.canceled = true;
        }
    }

    public void execute() throws IOException {
        if (this.result.length() > 0) {
            this.result = this.addMesgInfo(this.result);
            Node n = this.newAction.execute(this.p, this.result);
            this.plugin.getDataSet().addPrimitive((OsmPrimitive)n);
            if (Main.pref.getBoolean("osb.api.disabled")) {
                this.plugin.updateGui();
            } else {
                this.plugin.updateData();
            }
        }
    }

    public String toString() {
        return I18n.tr((String)("Create: " + this.result), (Object[])new Object[0]);
    }

    public OsbAction clone() {
        NewIssueAction action = new NewIssueAction(this.plugin, this.p);
        action.canceled = this.canceled;
        action.p = this.p;
        action.result = this.result;
        return action;
    }
}

