/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb;

import java.net.UnknownHostException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.osb.OsbDownloadLoop;
import org.openstreetmap.josm.plugins.osb.OsbLayer;
import org.openstreetmap.josm.plugins.osb.OsbUploadHook;
import org.openstreetmap.josm.plugins.osb.api.DownloadAction;
import org.openstreetmap.josm.plugins.osb.gui.OsbDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class OsbPlugin
extends Plugin
implements MapView.LayerChangeListener {
    private DataSet dataSet;
    private UploadHook uploadHook;
    private OsbDialog dialog;
    private OsbLayer layer;
    private DownloadAction download = new DownloadAction();

    public OsbPlugin(PluginInformation info) {
        super(info);
        this.initConfig();
        this.dataSet = new DataSet();
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            this.dialog = new OsbDialog(this);
            newFrame.addToggleDialog((ToggleDialog)this.dialog);
            MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
            this.uploadHook = new OsbUploadHook();
            UploadAction.registerUploadHook((UploadHook)this.uploadHook);
        } else {
            MapView.removeLayerChangeListener((MapView.LayerChangeListener)this);
            UploadAction.unregisterUploadHook((UploadHook)this.uploadHook);
            this.uploadHook = null;
            this.dialog = null;
        }
    }

    private void initConfig() {
        String include_date;
        String auto_download;
        String uri;
        String uriNew;
        String debug = Main.pref.get("osb.api.disabled");
        if (debug == null || debug.length() == 0) {
            debug = "false";
            Main.pref.put("osb.api.disabled", debug);
        }
        boolean oldApi = (uriNew = Main.pref.get("osb.uri.new")) != null && uriNew.contains("appspot");
        boolean switchApi = true;
        if (oldApi) {
            int choice = JOptionPane.showConfirmDialog(Main.parent, I18n.tr((String)"<html>The openstreetbugs plugin is using the old server at appspot.com.<br>A new server is available at schokokeks.org.<br>Do you want to switch to the new server? (Strongly recommended)</html>", (Object[])new Object[0]), I18n.tr((String)"Switch to new openstreetbugs server?", (Object[])new Object[0]), 0);
            boolean bl = switchApi = choice == 0;
        }
        if ((uri = Main.pref.get("osb.uri.edit")) == null || uri.length() == 0 || switchApi) {
            uri = "http://openstreetbugs.schokokeks.org/api/0.1/editPOIexec";
            Main.pref.put("osb.uri.edit", uri);
        }
        if ((uri = Main.pref.get("osb.uri.close")) == null || uri.length() == 0 || switchApi) {
            uri = "http://openstreetbugs.schokokeks.org/api/0.1/closePOIexec";
            Main.pref.put("osb.uri.close", uri);
        }
        if ((uri = Main.pref.get("osb.uri.download")) == null || uri.length() == 0 || switchApi) {
            uri = "http://openstreetbugs.schokokeks.org/api/0.1/getBugs";
            Main.pref.put("osb.uri.download", uri);
        }
        if ((uri = Main.pref.get("osb.uri.new")) == null || uri.length() == 0 || switchApi) {
            uri = "http://openstreetbugs.schokokeks.org/api/0.1/addPOIexec";
            Main.pref.put("osb.uri.new", uri);
        }
        if ((auto_download = Main.pref.get("osb.auto_download")) == null || auto_download.length() == 0) {
            auto_download = "true";
            Main.pref.put("osb.auto_download", auto_download);
        }
        if ((include_date = Main.pref.get("osb.include_date")) == null || include_date.length() == 0) {
            include_date = "true";
            Main.pref.put("osb.include_date", include_date);
        }
    }

    protected Bounds bounds() {
        MapView mv = Main.map.mapView;
        return new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
    }

    public void updateData() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (OsbPlugin.this.dialog != null) {
                        OsbPlugin.this.dialog.setEnabled(false);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Node selectedNode = this.getDialog().getSelectedNode();
        Bounds bounds = null;
        try {
            bounds = this.bounds();
        }
        catch (Exception e) {
            System.err.println("OpenStreetBugs: Couldn't determine bounds of currently visible rect. Cancel auto update");
            return;
        }
        if (!Main.pref.getBoolean("osb.api.offline")) {
            try {
                this.download.execute(this.dataSet, bounds);
                if (!this.dataSet.getNodes().isEmpty() && this.dialog.isDialogShowing() && Main.map != null && Main.map.mapView != null) {
                    this.updateGui();
                }
            }
            catch (Exception e) {
                if (e instanceof UnknownHostException) {
                    String message = String.format(I18n.tr((String)"Unknown Host: %s - Possibly there is no connection to the Internet.", (Object[])new Object[0]), e.getMessage());
                    JOptionPane.showMessageDialog(Main.parent, message);
                } else {
                    JOptionPane.showMessageDialog(Main.parent, e.getMessage());
                }
                e.printStackTrace();
            }
        }
        this.dialog.setSelectedNode(selectedNode);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OsbPlugin.this.dialog.setEnabled(true);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateGui() {
        this.dialog.update(this.dataSet);
        this.updateLayer(this.dataSet);
        Main.map.mapView.repaint();
    }

    private synchronized void updateLayer(DataSet osbData) {
        if (this.layer == null) {
            this.layer = new OsbLayer(osbData, "OpenStreetBugs", this.dialog);
            Main.main.addLayer((Layer)this.layer);
        }
    }

    public static ImageIcon loadIcon(String name) {
        return ImageProvider.get((String)name);
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            OsbDownloadLoop.getInstance().setPlugin(this);
        }
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == this.layer) {
            this.layer = null;
        }
    }

    public OsbLayer getLayer() {
        return this.layer;
    }

    public void setLayer(OsbLayer layer) {
        this.layer = layer;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public OsbDialog getDialog() {
        return this.dialog;
    }
}

